from dataiku.customrecipe import get_input_names_for_role, get_output_names_for_role, get_recipe_config

from cvae_oversample import run_cvae_oversample


config = get_recipe_config() or {}

input_names = get_input_names_for_role("input_dataset")
if not input_names:
    raise ValueError("No dataset provided for role 'input_dataset'")
input_name = input_names[0]

output_names = get_output_names_for_role("output_dataset")
if not output_names:
    raise ValueError("No dataset provided for role 'output_dataset'")
output_name = output_names[0]

run_cvae_oversample(input_dataset_name=input_name, output_dataset_name=output_name, config=config)
