/*
 * Decompiled with CFR 0.152.
 */
package com.tableau.hyperapi;

import com.sun.jna.Pointer;
import com.tableau.hyperapi.HyperAPI;
import com.tableau.hyperapi.Name;
import com.tableau.hyperapi.NativeHandleHelpers;
import com.tableau.hyperapi.SqlType;
import com.tableau.hyperapi.TypeTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

public final class ResultSchema {
    private ArrayList<Column> columns;

    ResultSchema(Pointer handle) {
        NativeHandleHelpers.checkHandleNotNull(handle);
        int columnCount = HyperAPI.hyper_table_definition_column_count(handle);
        this.columns = new ArrayList(columnCount);
        for (int position = 0; position < columnCount; ++position) {
            String name = HyperAPI.hyper_table_definition_column_name(handle, position);
            SqlType type = new SqlType(handle, position);
            Column column = new Column(new Name(name), type);
            this.columns.add(column);
        }
        assert (columnCount == this.columns.size());
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public Column getColumn(int position) {
        return this.columns.get(position);
    }

    public Optional<Column> getColumnByName(String columnName) {
        return this.getColumnByName(new Name(columnName));
    }

    public Optional<Column> getColumnByName(Name columnName) {
        for (Column column : this.columns) {
            if (!column.name.equals(columnName)) continue;
            return Optional.of(column);
        }
        return Optional.empty();
    }

    public OptionalInt getColumnPositionByName(String columnName) {
        return this.getColumnPositionByName(new Name(columnName));
    }

    public OptionalInt getColumnPositionByName(Name columnName) {
        for (int position = 0; position < this.columns.size(); ++position) {
            if (!this.columns.get(position).name.equals(columnName)) continue;
            return OptionalInt.of(position);
        }
        return OptionalInt.empty();
    }

    public static final class Column {
        private Name name;
        private SqlType type;

        public Column(Name columnName, SqlType type) {
            this.name = columnName;
            this.type = type;
        }

        public Name getName() {
            return this.name;
        }

        public SqlType getType() {
            return this.type;
        }

        public TypeTag getTypeTag() {
            return this.type.getTag();
        }
    }
}

