/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.export.tableau;

import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.code.ICodeEnvResolutionService;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.export.CustomPythonExportersService;
import com.dataiku.dip.io.KernelUtils;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.export.tableau.TableauExporter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class TableauUploadExporter
extends TableauExporter {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.export.tableau.server");
    private CustomPythonExportersService customPythonExporterService;
    private IPluginsRegistryService pluginsService;
    private ICodeEnvResolutionService codeEnvService;
    private File pluginDir;
    private JsonObject config;
    private JsonObject pluginSettings;
    private File destinationFile;
    private AutoDelete tmpDir;
    private String envName;

    @Override
    public void initialize(JsonObject config, JsonObject pluginSettings, Schema schema, ColumnFactory cf, File destinationFile) throws Exception {
        this.tmpDir = DSSTempUtils.getTempFolder((String)"tableau-upload");
        String outputTableName = config.get("output_table") == null ? "DSS_extract" : config.get("output_table").getAsString();
        outputTableName = outputTableName.replaceAll("[^A-Za-z0-9_]*", "");
        destinationFile = DKUFileUtils.getWithin((File)this.tmpDir, (String[])new String[]{outputTableName + ".hyper"});
        super.initialize(config, pluginSettings, schema, cf, destinationFile);
        this.initializeServices();
        this.config = config;
        this.pluginSettings = pluginSettings;
        this.destinationFile = destinationFile;
        this.envName = new CodeEnvSelector().selectForCustomPythonRecipe("tableau-hyper-export");
    }

    private void initializeServices() throws Exception {
        try {
            this.customPythonExporterService = (CustomPythonExportersService)SpringUtils.getBean(CustomPythonExportersService.class);
            this.pluginsService = (IPluginsRegistryService)SpringUtils.getBean(IPluginsRegistryService.class);
            this.codeEnvService = (ICodeEnvResolutionService)SpringUtils.getBean(ICodeEnvResolutionService.class);
            this.pluginDir = this.pluginsService.getActualPluginFolder("tableau-hyper-export");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize required services", e);
        }
    }

    @Override
    public void close() {
        if (this.tmpDir != null) {
            try {
                this.tmpDir.close();
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to cleanup temporary directory", (Throwable)e);
            }
        }
    }

    @Override
    public void stream(RowInputStream stream) throws Exception {
        try {
            this.processDataStream(stream);
            this.createUploaderConfig();
            this.executePythonUploader();
            logger.info((Object)"Upload to Tableau completed successfully");
        }
        catch (IOException e) {
            throw new RuntimeException("IO error during Tableau upload", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Upload process was interrupted", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to upload to Tableau: " + e.getMessage(), e);
        }
    }

    private void processDataStream(RowInputStream stream) throws Exception {
        super.stream(stream);
        super.close();
    }

    private void createUploaderConfig() throws IOException {
        JsonObject uploaderConfig = new JsonObject();
        uploaderConfig.add("config", (JsonElement)this.config);
        uploaderConfig.addProperty("hyperFilePath", this.destinationFile.getAbsolutePath());
        JSON.prettyToFile((Object)uploaderConfig, (File)DKUFileUtils.getWithin((File)this.tmpDir, (String[])new String[]{"uploader_config.json"}));
    }

    private void executePythonUploader() throws Exception {
        ProcessBuilder pb = this.createProcessBuilder();
        logger.info((Object)"Executing Python uploader");
        this.logProcessInfo(pb);
        DKUtils.execAndLogThrows((ProcessBuilder)pb);
    }

    private ProcessBuilder createProcessBuilder() throws IOException {
        List pyCmd = this.codeEnvService.getPythonCmd(this.envName, "N/A", (List)Lists.newArrayList((Object[])new String[]{DKUFileUtils.getWithin((File)this.pluginDir, (String[])new String[]{"java-driven-uploader", "uploader.py"}).getAbsolutePath()}));
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(pyCmd);
        pb.directory((File)this.tmpDir);
        try {
            KernelUtils.handlePythonAndRPath(null, null, (boolean)false, (Map)ImmutableMap.of((Object)"plugin-lib", (Object)this.pluginsService.getPluginPythonlibFolder("tableau-hyper-export").getAbsolutePath()), (File)this.tmpDir, (boolean)false, (ProcessBuilder)pb);
        }
        catch (Exception e) {
            throw new RuntimeException("Security error while setting up Python path", e);
        }
        return pb;
    }

    private void logProcessInfo(ProcessBuilder pb) {
        logger.info((Object)("Python command: " + pb.command().get(0) + " <script>"));
        logger.info((Object)("Working directory: " + pb.directory().getAbsolutePath()));
        logger.info((Object)("Environment name: " + this.envName));
    }
}

