# Development Setup

## Project Overview

Trace Explorer is a Dataiku plugin for visualizing LLM Mesh traces. It has a Python/Flask backend and a TypeScript/Vue frontend.

## Commands

### Frontend (`resource/frontend/`)

```sh
pnpm install          # Install dependencies
pnpm dev              # Start dev server with HMR
pnpm build            # Type-check and build for production
pnpm lint             # Run oxlint then eslint with auto-fix
pnpm format           # Format code with Prettier
pnpm test:unit        # Run unit tests with Vitest
pnpm test:e2e         # Run Playwright e2e tests
```

### Backend (from project root)

```sh
uv venv .venv && source .venv/bin/activate
uv pip install -r code-env/python/spec/requirements.txt
python ./python-lib/wsgi.py   # Start Flask dev server
```

Backend requires symlinks to Dataiku's `dataiku` and `dataikuapi` modules in `.venv/lib/python3.x/site-packages/`.

## Configuration

Backend reads `python-lib/traces_explorer/backend/utils/local_config.json` for standalone mode:

```json
{
  "webapp_config": {
    "llm_responses_dataset": "history_dataset",
    "llm_responses_column": "llm_context"
  },
  "default_project_key": "DEFAULT_PROJECT"
}
```

Frontend API URL is resolved from DSS via `getWebAppBackendUrl()` when available,
and falls back to `http://localhost:5000`. Local dev proxying uses `VITE_API_PORT`
to forward `/api` requests (see `resource/frontend/vite.config.ts`).

## Frontend Local Storage

The frontend stores user preferences in `localStorage`:

| Key | Description | Values |
|-----|-------------|--------|
| `vueuse-color-scheme` | Theme preference | `light`, `dark`, `auto` |
| `trace-explorer-default-trace-view` | Default trace visualization | `explorer`, `timeline`, `tree` |
| `trace-explorer-default-node-view` | Default node inspector view | `formatted`, `raw` |
| `trace_explorer_*_local_trace` | Pasted trace data | JSON trace object |
