"""
Utility functions for API responses.
"""
import json
from typing import Any


def return_ok(data: Any = None, message: str = "") -> str:
    """
    Return success response.

    Args:
        data: Response data (optional)
        message: Optional message (optional)

    Returns:
        JSON string with status "ok"
    """
    response = {"status": "ok"}
    if data is not None:
        response["data"] = data
    if message:
        response["message"] = message
    return json.dumps(response)


def return_error(message: str = "", data: Any = None) -> str:
    """
    Return error response.

    Args:
        message: Error message
        data: Optional error details

    Returns:
        JSON string with status "error"
    """
    response = {"status": "error", "message": message}
    if data is not None:
        response["data"] = data
    return json.dumps(response)
