import { useLocalStorage } from '@vueuse/core'
import type { TraceViewMode, NodeViewMode } from '@/stores/uiStore'

/**
 * Composable for managing user settings persisted to localStorage
 *
 * @returns Reactive refs for default trace view and node view settings
 */
export function useSettings() {
  const defaultTraceView = useLocalStorage<TraceViewMode>(
    'trace-explorer-default-trace-view',
    'explorer',
  )
  const defaultNodeView = useLocalStorage<NodeViewMode>(
    'trace-explorer-default-node-view',
    'formatted',
  )

  return {
    defaultTraceView,
    defaultNodeView,
  }
}
