/**
 * Returns whether the app is running inside an iframe.
 *
 * In cross-origin embeds, reading `window.top` can throw; in that case we
 * conservatively return `true`.
 */
export function inIframe(): boolean {
  try {
    return window.self !== window.top
  } catch {
    // if we can't access window.top due to cross-origin, we're in an iframe
    return true
  }
}
