import type { TraceNode } from '@/common/interface/trace'

export function findNodeById(node: TraceNode, id: string): TraceNode | null {
  if (!node || !id) return null
  if (node.id === id) return node as TraceNode
  if (node.children) {
    for (const c of node.children) {
      const found = findNodeById(c, id)
      if (found) return found
    }
  }
  return null
}
