import type { TraceNode } from '@/common/interface/trace'

const inputKeys = ['messages']
const outputKeys = ['text', 'toolCalls', 'output']

export enum FormatPanelType {
  Inputs = 'inputs',
  Outputs = 'outputs'
}

const keysToCheck: string[] = ['attributes', 'usageMetadata', 'inputs', 'outputs']

function isEmpty(val: any): boolean {
  if (val == null) return true
  if (typeof val === 'object') {
    return Object.keys(val).length === 0
  }
  return false
}

function allEmptyKeys(obj: Record<string, any>, keys: string[]): boolean {
  return keys.every((k) => isEmpty(obj[k]))
}

export function isEmptyNode(rawNode: TraceNode): boolean {
  return allEmptyKeys(rawNode, keysToCheck)
}

export function isEmptyPanel(nodeObj: any, panelType: FormatPanelType): boolean {
  const necessaryKeys =
    panelType === FormatPanelType.Inputs
      ? inputKeys
      : panelType === FormatPanelType.Outputs
        ? outputKeys
        : []
  const isEmptyNode = !nodeObj || (typeof nodeObj === 'object' && Object.keys(nodeObj).length === 0)
  if (necessaryKeys.length > 0 && !isEmptyNode) {
    const hasKeys = Object.keys(nodeObj).some((key) => necessaryKeys.includes(key))
    return !hasKeys
  }
  return isEmptyNode
}
