# Documentation Index

Use this folder as the canonical contributor and agent documentation set.

## Quick Start

1. Read `AGENTS.md` for mandatory guardrails and workflow defaults.
2. Use `docs/development-setup.md` to run the project locally.
3. Use `docs/architecture.md` to understand boundaries and data flow.
4. Follow `docs/engineering-guidelines.md` for coding patterns and quality checks.
5. Follow `docs/ui-ux-guidelines.md` for all UI changes.

## Document Map

- `docs/development-setup.md`
  - local setup commands
  - backend/frontend configuration
  - localStorage keys and runtime notes
- `docs/architecture.md`
  - frontend/backend structure
  - request and state data flow
  - concurrency model and API endpoints
- `docs/engineering-guidelines.md`
  - architecture and layering rules
  - TanStack Query and Pinia usage patterns
  - component/composable patterns
  - comment conventions and quality checklist
- `docs/ui-ux-guidelines.md`
  - UI/UX constraints and consistency requirements
  - impact assessment expectations
  - implementation checklist before PR

## Precedence

If guidance conflicts, use this order:

1. `AGENTS.md`
2. `docs/*.md`
3. historical or legacy notes
