# UI/UX Guidelines

## Core Principles

When creating, updating, or reworking frontend components, follow these rules.

### 1. Preserve Existing Layout

- Do not change overall application layout structure by default.
- Keep existing navigation patterns, page hierarchy, and user flows intact.

### 2. Impact Assessment Is Required

Before implementation:

- evaluate if changes can break existing features
- assess whether quality, aesthetics, or functionality could regress
- explicitly state concerns and risks
- propose alternatives when a request may be detrimental

### 3. Design Consistency

Match existing styles unless explicitly told otherwise:

- same color palette and semantic color roles
- same typography hierarchy (families, sizes, weights)
- same icon style/set
- consistent spacing, borders, shadows, and radii

Always audit nearby components before introducing new patterns.

### 4. Design Quality Standards

Aim for top-tier, modern design quality:

- clean, polished, professional visuals
- strong whitespace and hierarchy
- smooth, purposeful animations
- attention to micro-interactions
- accessible, intuitive patterns

### 5. Design Inspiration Sources

Reference quality patterns from:

- LangSmith (developer tooling interfaces)
- Anthropic/Claude (clean modern AI interfaces)
- comparable AI developer products

Target characteristics:

- sophisticated but approachable aesthetics
- clear information hierarchy
- modern, high-contrast palettes
- thoughtful depth (gradients/shadows)
- professional typography and spacing

### 6. Purpose-Driven Design

- prioritize core tasks and problem-solving outcomes
- do not trade usability/functionality for aesthetics
- ensure visual changes improve, not hinder, workflows

## Implementation Checklist

Before finalizing UI changes:

- [ ] layout structure is preserved
- [ ] styles align with existing system
- [ ] no existing feature is broken or degraded
- [ ] user experience is improved or maintained
- [ ] design quality meets modern professional standards
- [ ] core purpose/functionality remains intact
- [ ] concerns/risks are clearly communicated

## When in Doubt

If unsure, ask for clarification or propose the change with explicit risks before implementing.
