import { api } from '@/api/client'
import type { Trace } from '@/types/trace'

export const tracesService = {
  reload: () => api.get('api/traces/reload').json<{ data: { message: string }; status: string }>(),
  listAll: () => api.get('api/traces/list').json<{ data: Trace[]; status: string }>(),
  getOne: (id: string) =>
    api.get(`api/traces/get_trace/${id}`).json<{ data: Trace; status: string }>(),
  process: (payload: { traceJson: string; name?: string }) =>
    api.post('api/traces/process', { json: payload }).json<{ data: Trace; status: string }>(),
}
