import type { TraceNode } from '@/types/trace'

/**
 * Shared type definitions for Explorer components
 */

/**
 * Represents the visual state of a connector line
 * - empty: No line rendered
 * - filled: Normal gray line
 * - highlighted: Emphasized blue line (thicker)
 */
export type ConnectorVariant = 'empty' | 'filled' | 'highlighted'

/**
 * Props for child items with highlighting information
 */
export interface ChildItemWithHighlight {
  item: TraceNode
  isLast: boolean
  highlighted: boolean
}
