/**
 * Interface representing a flattened item on the timeline.
 */
export interface TimelineItem {
  id: string
  label: string
  start: Date
  end: Date
  group: string
  icon: string
  color: string
  /** Depth level in the original tree structure, used for visual indentation if needed */
  depth: number
  hasChildren: boolean
}

// layout constants
export const ROW_HEIGHT = 32
export const AXIS_HEIGHT = 20
export const BOTTOM_PADDING = 16
