import type { TraceNode } from '@/types/trace'

/**
 * Recursively finds the path of ancestor IDs leading to the target node.
 */
export function getAllAncestors(
  node: TraceNode,
  targetId: string,
  parents: string[] = [],
): string[] | null {
  if (node.id === targetId) return parents
  if (node.children) {
    for (const child of node.children) {
      const result = getAllAncestors(child as TraceNode, targetId, [...parents, node.id || ''])
      if (result) return result
    }
  }
  return null
}

/**
 * Recursively collects IDs of all nodes that have children.
 */
export function getAllParentIds(node: TraceNode, ids: string[] = []): string[] {
  if (node.children && node.children.length > 0) {
    if (node.id) ids.push(node.id)
    for (const child of node.children) {
      getAllParentIds(child as TraceNode, ids)
    }
  }
  return ids
}
