export function parseDeep(value: any): any {
  if (typeof value === 'string') {
    try {
      return parseDeep(JSON.parse(value))
    } catch {
      return value
    }
  }
  if (Array.isArray(value)) {
    return value.map(parseDeep)
  }
  if (value && typeof value === 'object') {
    const newObj: Record<string, any> = {}
    for (const [k, v] of Object.entries(value) as [string, any][]) {
      newObj[k] = parseDeep(v)
    }
    return newObj
  }
  return value
}
