import 'dotenv/config'
import path from 'node:path'
import tailwindcss from '@tailwindcss/vite'
import vue from '@vitejs/plugin-vue'
import { defineConfig } from 'vite'

const clientPort = process.env['VITE_CLIENT_PORT']
const apiPort = process.env['VITE_API_PORT']
const basePath = process.env[`DKU_CODE_STUDIO_BROWSER_PATH_${clientPort}`]
  ? String(process.env[`DKU_CODE_STUDIO_BROWSER_PATH_${clientPort}`]) + '/'
  : ''

export default defineConfig({
  plugins: [vue(), tailwindcss()],
  resolve: {
    alias: {
      '@': path.resolve(__dirname, './src')
    }
  },
  build: {
    outDir: '../dist',
    emptyOutDir: true,
    rollupOptions: {
      output: {
        entryFileNames: `assets/[name].js`,
        chunkFileNames: `assets/[name].js`,
        assetFileNames: `assets/[name].[ext]`
      }
    }
  },
  base: basePath,
  server: {
    host: '127.0.0.1',
    port: Number(clientPort),
    proxy: {
      '/api': {
        target: `http://127.0.0.1:${apiPort}`,
        changeOrigin: true,
        secure: false,
        rewrite: (path) => path.replace(/^\/api/, '/api')
      }
    }
  }
})
