export interface TimelineItem {
  id: number
  group: number
  content: string
  start: Date
  end: Date
  type: string
  className: string
  data: {
    actualNodeId: string | undefined
    name: string
    startTime: Date
    endTime: Date
    duration: number
    group: string
  }
  emptyNode: boolean
}

export interface MinMaxDuration {
  minDuration: number
  maxDuration: number
}

export interface TimelineNodeData {
  id: any
  label: any
  group: string
  collapsed: boolean
  expandable: boolean
  details: {}
  fullLabel: any
  rawDuration: any
  begin: any
  end: any
  _childElements: {
    nodes: TimelineNode[]
    edges: TimelineEdge[]
  }
  emptyNode: boolean
}

export interface TimelineNode {
  data: TimelineNodeData
}

export interface EdgeData {
  source: string
  target: string | undefined
}

export interface TimelineEdge {
  data: EdgeData
}

export interface KeyValuePair {
  key: string
  value: string
}

export interface NodeDetails {
  inputs: KeyValuePair[]
  outputs: KeyValuePair[]
  attributes: KeyValuePair[]
}
