export interface Trace {
  id: string
  parentNode?: TraceNode
  name?: string
  begin?: string
  duration?: number
  date?: Date
  overallTotalPromptTokens?: number
  overallTotalCompletionTokens?: number
  overallTotalTokens?: number
  overallEstimatedCost?: number
}

export interface TraceNode {
  id?: string
  traceName?: string
  type: string
  begin?: string
  end?: string
  timestamp?: string
  date?: Date
  duration?: number
  name: string
  children: (TraceNode | TraceNodeEvent)[]
  attributes: SpanAttributes
  usageMetadata?: UsageMetadata
  inputs?: SpanInputsOutputs
  outputs?: SpanInputsOutputs
}

export interface TraceNodeEvent {
  type: string
  timestamp: string
  name: string
  children: any[]
  attributes: Record<string, any>
  id?: string
}

export interface UsageMetadata {
  promptTokens: number
  completionTokens: number
  totalTokens: number
  estimatedCost: number
}

interface Message {
  role: string
  content?: string
  text?: string
}

interface CompletionQuery {
  messages: Message[]
}

interface CompletionQuerySettings {
  maxOutputTokens: number
  stopSequences: string[]
}

interface CompletionResponse {
  ok: boolean
  text: string
  finishReason: string
  toolCalls: any[]
  predictedClassProbas: any[]
  fromCache: boolean
  promptTokens?: number
  completionTokens?: number
  totalTokens?: number
  estimatedCost?: number
}

interface SpanAttributes {
  llmId?: string
  llmProvider?: string
  llmModel?: string
  completionQuery?: CompletionQuery
  completionQuerySettings?: CompletionQuerySettings
  completionResponse?: CompletionResponse
}

interface SpanInputsOutputs {
  messages?: Message[]
  text?: string
  toolCalls?: ToolCall[]
  output?: Output
}

interface FunctionCall {
  arguments: string
  name?: string
}

export interface ToolCall {
  type: string
  function: FunctionCall
  index: number
  id?: string
}

export interface Source {
  toolCallDescription?: string
  items?: object[]
}

export interface Output {
  content: string
  status: string
  name: string
  sources: Source[]
}

export interface ChildListItem {
  name: string
  id?: string
  nodeGrp: string | null
  emptyNode?: boolean
}
