import { defineStore } from 'pinia'
import { ref, type Ref } from 'vue'
import type {
  FormattedPanelExpansions,
  JsonPanelExpansions
} from '@/common/interface/panelSelection'

export const usePanelSelectionStore = defineStore('panel', () => {
  // We're only interested in storing whether the selection is fully
  // open or minimal open this is why we use boolean
  const formattedExpansions: Ref<FormattedPanelExpansions> = ref({
    // start fully opened
    inputs: true,
    outputs: true
  })
  const jsonExpansions: Ref<JsonPanelExpansions> = ref({
    // start minimal open
    attributes: false,
    inputs: false,
    outputs: false,
    usageMetaData: false
  })

  function toggleFormattedSelection(key: keyof FormattedPanelExpansions) {
    formattedExpansions.value[key] = !formattedExpansions.value[key]
  }

  function setFormattedSelection(key: keyof FormattedPanelExpansions, value: boolean) {
    formattedExpansions.value[key] = value
  }

  function toggleJsonSelection(key: keyof JsonPanelExpansions) {
    jsonExpansions.value[key] = !jsonExpansions.value[key]
  }

  function setJsonSelection(key: keyof JsonPanelExpansions, value: boolean) {
    jsonExpansions.value[key] = value
  }

  return {
    formattedExpansions,
    jsonExpansions,
    toggleFormattedSelection,
    setFormattedSelection,
    toggleJsonSelection,
    setJsonSelection
  }
})
