# Repository Guidelines

## Read This First
Use this file as a fast entrypoint, then open the focused docs:

- `docs/development-setup.md`: local setup, commands, env/config, localStorage keys
- `docs/architecture.md`: stack, module boundaries, data flow, concurrency, API endpoints
- `docs/engineering-guidelines.md`: coding patterns, TanStack Query/Pinia rules, component patterns, comment style, code quality checklist
- `docs/ui-ux-guidelines.md`: mandatory UI/UX design and review standards

## Shared Knowledge Base
- Additional cross-repository reference material is available in `~/.codex/shared/`.
- Critical DSS trace reference: `~/.codex/shared/trace_knowledge/llm_mesh_trace_structure.md` (authoritative structure details for LLM Mesh traces).
- For repository-specific decisions, prefer local precedence in this order:
  1. `AGENTS.md`
  2. `docs/*.md`
  3. `~/.codex/shared/*`

## Project Structure
- `resource/frontend/`: Vue 3 + TypeScript frontend app
- `python-lib/traces_explorer/backend/`: Flask backend (`routes/`, `services/`, `repositories/`, `models/`, `utils/`)
- `webapps/traces-explorer/`: DSS webapp integration files
- `resource/dist/`: built frontend artifacts bundled in plugin

## Non-Negotiable Engineering Rules
- Respect backend layering: routes -> services -> repositories.
- Keep route handlers thin; no business logic in controllers.
- Use TanStack Query for server data, Pinia for client/UI state.
- Do not duplicate server cache data in Pinia stores.
- Maintain thread safety for shared backend state (`RWLock` patterns).

## Non-Negotiable UI/UX Rules
- Preserve existing layout/navigation structure unless explicitly requested.
- Match existing design language (colors, typography, iconography, spacing).
- Assess regression risk before UI changes and state concerns clearly.
- Include visual evidence (screenshots/GIFs) in PRs for UI changes.

## Development and Validation
- Frontend: `pnpm lint`, `pnpm test:unit`, relevant `pnpm test:e2e`.
- Backend: run local Flask server and validate changed endpoints.
- Packaging: use `make dev` for local archive and `make plugin` for release flow.

## Commit and PR Expectations
- Use concise, imperative commits (common prefixes: `fix:`, `build:`, `UI/UX`).
- Keep commits atomic and scoped to one logical change.
- PRs must include purpose, impacted areas, test evidence, linked issue/ticket, and UI captures when applicable.
