# Architecture

## Frontend Stack

- Vue 3 with Composition API and `<script setup>`
- Pinia for state management
- TanStack Query (`@tanstack/vue-query`) for server state/caching
- Tailwind CSS v4 with class-variance-authority (cva)
- Reka UI as headless component primitives
- ky for HTTP requests

## Key Frontend Paths

- `resource/frontend/src/api/` - API client (`ky`) and service functions
- `resource/frontend/src/stores/` - Pinia stores
- `resource/frontend/src/composables/` - Vue composables for shared logic
- `resource/frontend/src/components/ui/` - reusable UI primitives (shadcn/ui style)
- `resource/frontend/src/components/` - reusable components
- `resource/frontend/src/views/` - route pages
- `resource/frontend/src/types/` - TypeScript interfaces

## Data Flow

### Initial Load Sequence

1. App mount: `App.vue` calls `useAppInitialization()`.
2. Local trace: reads from LocalStorage and sets in store (if present).
3. Explore trace (URL param): `POST /api/traces/process`, store result locally, select, and navigate.
4. Trace list: `useTraces()` (via store) fetches `GET /api/traces/list` when the store is used.

### Runtime Data Flow

1. `tracesService` calls Flask API via ky client.
2. `useTraces`/`useTrace` composables wrap TanStack Query for server state.
3. Pinia store holds UI state (selection, filters).
4. Views consume both TanStack Query data and Pinia state reactively.
5. Reload: `useReloadTraces()` calls `/api/traces/reload` and refetches the traces list.

### Concurrency Model

- Backend: Flask dev server runs via `app.run(..., debug=True)` without explicit threading config.
- Repository: `RWLock` allows multiple concurrent reads and exclusive writes.
- Frontend: TanStack Query handles request concurrency and deduplication.

## Backend Structure

- `python-lib/wsgi.py` - Flask app entry point
- `python-lib/traces_explorer/backend/routes/api/traces.py` - trace endpoints (thin controllers)
- `python-lib/traces_explorer/backend/services/` - business logic layer
- `python-lib/traces_explorer/backend/repositories/` - data access layer
- `python-lib/traces_explorer/backend/models/` - data models
- `python-lib/traces_explorer/backend/utils/` - Dataiku API helpers, logging, thread safety

## API Endpoints

- `GET /api/traces/list` - list all traces (summary)
- `GET /api/traces/get_trace/<id>` - get full trace with node tree
- `GET /api/traces/reload` - reload traces from dataset
- `POST /api/traces/process` - process pasted trace JSON and return full trace
