import os

from dotenv import load_dotenv
from flask import Flask
from traces_explorer.backend.utils.local_config import setup_dataiku_client
from traces_explorer.backend.utils.logging import logger

load_dotenv()

def register_blueprints(app):
    from traces_explorer.backend.routes import api
    app.register_blueprint(blueprint=api)

def setup_local_app():
    app = Flask(__name__)
    from flask_cors import CORS

    CORS(app)
    logger.info("Creating Flask Application")
    setup_dataiku_client()

    register_blueprints(app)

    app.debug = True
    return app

if __name__ == "__main__":
    os.environ["FLASK_ENV"] = "development"
    app = setup_local_app()
    logger.info("Running Application")
    app.run(host="127.0.0.1", port=int(os.getenv("VITE_API_PORT")), debug=True)
