import type { VariantProps } from "class-variance-authority"
import { cva } from "class-variance-authority"

export { default as Button } from "./Button.vue"

export const buttonVariants = cva(
  "inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive uppercase hover:cursor-pointer",
  {
    variants: {
      variant: {
        default:
          "bg-primary text-primary-foreground hover:bg-primary/90 text-white",
        destructive:
          "bg-destructive text-white hover:bg-destructive/90 focus-visible:ring-destructive/20 dark:focus-visible:ring-destructive/40 dark:bg-destructive/60",
        outline:
          "border bg-background text-foreground/60 dark:bg-input/30 dark:border-input dark:hover:bg-input/50",
        secondary:
          "border border-primary text-primary hover:bg-primary/5",
        ghost:
          "text-muted-foreground hover:bg-sidebar-accent dark:hover:bg-accent/50",
        link:
          "text-primary hover:underline !px-0",
        menu:
          "justify-start text-left w-full font-normal normal-case hover:bg-sidebar-accent",
      },
      size: {
        "default": "text-[13px] h-8 px-4 py-2 has-[>svg]:px-3",
        "sm": "rounded-[4px] h-7 gap-1.5 px-2 py-[1px] has-[>svg]:px-2.5",
        "lg": "h-10 px-6 has-[>svg]:px-4",
        "icon": "size-9",
        "icon-xs": "size-7",
        "icon-sm": "size-8",
        "icon-lg": "size-10",
        "menu": "h-auto px-2 py-1.5 gap-3",
      },
    },
    defaultVariants: {
      variant: "default",
      size: "default",
    },
  },
)
export type ButtonVariants = VariantProps<typeof buttonVariants>
