import { DateFormatter } from '@internationalized/date'

/**
 * useFormatters - Returns formatters for dates and times
 *
 * @returns {Object} An object containing the formatters
 */
export function useFormatters() {
  const simpleDateFormatter = new DateFormatter('en-US', {
    dateStyle: 'medium',
  })
  const simpleDateTimeFormatter = new DateFormatter('en-US', {
    dateStyle: 'medium',
    timeStyle: 'short',
  })
  const simpleTimeFormatter = new DateFormatter('en-US', {
    timeStyle: 'medium',
  })
  const fullTimeFormatter = new DateFormatter('en-US', {
    timeStyle: 'long',
  })
  const preciseTimeFormatter = new Intl.DateTimeFormat('en-US', {
    hour: 'numeric',
    minute: '2-digit',
    second: '2-digit',
    fractionalSecondDigits: 3,
  } as Intl.DateTimeFormatOptions)
  const numberFormatter = new Intl.NumberFormat('en-US', {
    style: 'decimal',
    minimumFractionDigits: 0,
    maximumFractionDigits: 2,
  })

  function formatMillis(ms: number | undefined): string {
    if (!ms) return '0'

    return `${numberFormatter.format(ms)} ms`
  }

  function formatCost(value: number): string {
    return `${value.toLocaleString('en-US', { maximumFractionDigits: 10 })}`
  }

  return {
    simpleDateFormatter,
    simpleDateTimeFormatter,
    simpleTimeFormatter,
    fullTimeFormatter,
    preciseTimeFormatter,
    numberFormatter,
    formatMillis,
    formatCost,
  }
}
