import { useRouter } from 'vue-router'
import { useUiStore } from '@/stores/uiStore'
import { WT1iser } from '@/services/wt1'

export function useNavigation() {
  const router = useRouter()
  const uiStore = useUiStore()

  function backToTraces() {
    uiStore.selectTrace(undefined)
    router.push({ name: 'traceList' })
  }

  function goToTrace(traceId: string) {
    WT1iser.selectTrace(traceId)
    uiStore.selectTrace(traceId)
    router.push({ name: 'trace', params: { traceId: traceId } })
  }

  function goToNode(nodeId: string) {
    WT1iser.openNodeDetails(nodeId)
    uiStore.toggleSelectNode(nodeId)
    router.push({ name: 'node', params: { traceId: uiStore.selectedTraceId, nodeId } })
  }

  return {
    backToTraces,
    goToTrace,
    goToNode,
  }
}
