/** Color classes for message roles */
export const roleColorClasses: Record<string, string> = {
  user: 'text-blue-600 dark:text-white bg-blue-100 dark:bg-blue-500/90',
  assistant: 'text-violet-600 dark:text-white bg-violet-100 dark:bg-violet-500/80',
  system: 'text-amber-600 dark:text-white bg-amber-100 dark:bg-amber-600/90',
  tool: 'text-emerald-600 dark:text-white bg-emerald-100 dark:bg-emerald-500/90',
  error: 'text-red-600 dark:text-white bg-red-100 dark:bg-red-600/70',
  input: 'text-cyan-600 dark:text-white bg-cyan-100 dark:bg-cyan-500',
  output: 'text-teal-600 dark:text-white bg-teal-100 dark:bg-teal-500',
  memoryfragment: 'text-slate-600 dark:text-white bg-slate-100 dark:bg-slate-600/70',
  sources: 'text-indigo-600 dark:text-white bg-indigo-100 dark:bg-indigo-500/90',
  artifacts: 'text-purple-600 dark:text-white bg-purple-100 dark:bg-purple-500/90',
  detectedentities: 'text-orange-600 dark:text-white bg-orange-100 dark:bg-orange-500/90',
  text: 'text-fuchsia-600 dark:text-white bg-fuchsia-100 dark:bg-fuchsia-500/70',
}

/** Default color class for unknown roles */
export const defaultRoleColorClass = 'text-muted-foreground bg-muted'

/**
 * Get the color classes for a given role
 *
 * @param role - The message role (user, assistant, system, tool, etc.)
 * @returns Tailwind color classes for text and background
 */
export function getRoleColorClass(role: string): string {
  return roleColorClasses[role.toLowerCase()] ?? defaultRoleColorClass
}
