# Vertex AI Agents Plugin for Dataiku

Connect and interact with Google Cloud Vertex AI Agent Engine Agents directly from Dataiku DSS. This plugin supports both **Langchain** and **Google ADK (Agent Development Kit)** frameworks for building powerful agentic AI applications.

---

## 🚀 Features

- **Streaming Responses**: Real-time asynchronous streaming output from agents for interactive conversations 
- **Authentication**: Support for both Service Account and OAuth authentication of [Dataiku Vertex AI LLM Connection](https://doc.dataiku.com/dss/latest/generative-ai/llm-connections.html#google-vertex-generative-ai)
- **Agent Discovery**: Automatically fetch and list available agents from your Vertex AI project

---

## 📋 Prerequisites

### Dataiku Requirements
- Dataiku DSS version 14.3.0 or later
- Python 3.10 or later

### Google Cloud Requirements
- Vertex AI LLM Connection in Dataiku (using either Private key or OAuth credentials)
- Agents deployed on Vertex AI Agent Engine (Langchain or ADK framework)

---

## 📦 Installation
- Follow the Dataiku guide to [install plugins](https://doc.dataiku.com/dss/latest/plugins/installing.html)
- The plugin will create a code environment with the following dependencies:

```bash
# Core dependencies
google-cloud-aiplatform
google-auth
vertexai
```

## 🎯 Usage

### Create & Configure an Agent in Dataiku

1. **Create Agent in Project**
   - Go to your Dataiku project
   - Click on **Agents & GenAI Models** --> Click on **+New Agent**
   - Select **Vertex AI - Agents** & Provide a unique name
   - Alternate way is to go to Project Flow --> **ADD ITEM** --> **Generative AI** --> **Vertex AI - Agents**

   ![Vertex AI Agent Creation](assets/vertex-ai-agent-creation-option.png)

2. **Configure Agent**
   - **Connection**: Select your Vertex AI LLM Connections in Dataiku
   - **Agent Framework**: Choose framework type:
     - **Langchain**: For agents build with Langchain framework
     - **Google ADK**: For agents built with Google's Agent Development Kit
   - **Agent Name**: Select from the dropdown of available agents. The list refreshes once you select the connection and framework.

   *Note: If the agent list doesn't refresh, click **Save** and refresh your browser.*

   ![List of Vertex AI Agents](assets/list-of-vertex-ai-agents.png)

3. **Test Agent**
   - Use the built-in chat interface to test your agent
   - Verify responses are streaming correctly

   ![Test Query with Vertex AI Agent](assets/test-query-vertex-ai-agent.png)

---

## 🚧 Limitations

- **Chat Context**:
	**ADK**: For ADK Agents, conversationId is required in the context. This is handled both by Agent Hub and the native chat interface of Dataiku DSS.
- **Multi-modal**: Text-only support
