from __future__ import annotations

from pydantic import BaseModel

from ..graph_db_instance_manager import EditorWebAppDbInstance
from ..models import GraphId
from ..store.graph_metadata_snapshot_store import GraphMetadataSnapshotStore
from ..store.graph_metadata_store import GraphMetadataStore


class Params(BaseModel):
    graph_id: GraphId


def delete_graph(store: GraphMetadataStore, snapshot_store: GraphMetadataSnapshotStore | None, params: Params) -> None:
    """
    Raises:
        GraphDoesNotExistError
        GraphMetadataStoreError
    """
    graph_id = params.graph_id
    try:
        store.delete(graph_id)
        if snapshot_store:
            snapshot_store.delete_all(graph_id)
    finally:
        with EditorWebAppDbInstance(graph_id, readonly=False) as local_db_instance:
            if local_db_instance.exists():
                local_db_instance.destroy()
