import dataiku


def do(payload, config, plugin_config, inputs):
    client = dataiku.api_client()
    project = client.get_project(dataiku.get_custom_variables()["projectKey"])
    managed_folders = project.list_managed_folders()
    choices = [
        {"value": folder["name"], "label": folder["name"]}
        for folder in managed_folders
        if folder["type"] in ["S3", "Filesystem"]
    ]
    return {"choices": choices}
