from __future__ import annotations

from flask import Blueprint

from explorer.backend.utils.webapp_config import webapp_config
from solutions.backend.utils import return_ok
from solutions.graph.queries.explorer_data import (
    get_snapshot_metadata,
    get_snapshots_metadata_from_folders,
)

graph_snapshot = Blueprint("graph_snapshot", __name__, url_prefix="/snapshots")


@graph_snapshot.route("", methods=["GET"])
def get_snapshots():
    folders = webapp_config.db_explorer_folders
    snapshots = get_snapshots_metadata_from_folders(folders)
    return return_ok(data={"snapshots": snapshots})



@graph_snapshot.route("<snapshot_id>", methods=["GET"])
def get_snapshot(snapshot_id: str):
    folders = webapp_config.db_explorer_folders

    content = get_snapshot_metadata(snapshot_id, folders)
    return return_ok(data=content)
