from flask import Blueprint

from .config import config
from .graph_cypher import graph_cypher
from .graph_queries import graph_queries
from .graph_snapshot import graph_snapshot
from .llm import llm

api = Blueprint("api", __name__, url_prefix="/api")

api.register_blueprint(graph_snapshot)
api.register_blueprint(graph_cypher)
api.register_blueprint(graph_queries)
api.register_blueprint(llm)
api.register_blueprint(config)
