import dataiku

from solutions.graph.explorer_builder import DbInstanceFactory
from solutions.graph.kuzu.schema import schema_extractor


def do(payload, config, plugin_config, inputs):
    input_db_folder = dataiku.Folder(inputs[0]["fullName"])
    parameter_name = payload["parameterName"]

    if parameter_name == "path_to_db":
        db_paths_choices = []
        for path in input_db_folder.list_paths_in_partition():
            if path.lower().endswith('.kz'):
                rel_path = path.lstrip('/')
                db_paths_choices.append({"value": rel_path, "label": rel_path})

        return {"choices": db_paths_choices}
    elif parameter_name == "node_groups":
        if root_model := payload.get("rootModel", ""):
            if path_to_db := root_model.get("path_to_db", ""):
                with DbInstanceFactory([input_db_folder]).get_db_instance_from_db_path(input_db_folder, path_to_db) as db_instance:
                    schema = schema_extractor.extract_schema(db_instance)
                    choices = [{"label": k, "value": k} for k in schema["node_groups"].keys()]
                    return {"choices": choices}

        return {"choices": []}
    elif parameter_name == "edge_groups":
        if root_model := payload.get("rootModel", ""):
            if path_to_db := root_model.get("path_to_db", ""):
                with DbInstanceFactory([input_db_folder]).get_db_instance_from_db_path(input_db_folder, path_to_db) as db_instance:
                    schema = schema_extractor.extract_schema(db_instance)
                    choices = [{"label": k, "value": k} for k in schema["edge_groups"].keys()]
                    return {"choices": choices}

        return {"choices": []}
    else:
        raise Exception(f"Unexpected parameter name '{parameter_name}'.")
