from flask import Blueprint, request

from editor.backend.utils.api import use_graph_metadata_store
from editor.backend.utils.webapp_config import webapp_config
from solutions.backend.utils import return_ok
from solutions.graph.queries import run_cypher as run_cypher_query
from solutions.graph.queries.graph_data import RunCypherParams
from solutions.graph.store.graph_metadata_store import GraphMetadataStore

graph_cypher = Blueprint("cypher", __name__, url_prefix="/cypher")


@graph_cypher.route("/run", methods=["POST"])
@use_graph_metadata_store
def run_cypher(graph_store: GraphMetadataStore):
    params = RunCypherParams(**request.get_json())

    result = run_cypher_query(graph_store, params, webapp_config.db_query_timeout_seconds)

    return return_ok(data=result)
