import logging

from dataiku import api_client
from flask import Response, g, jsonify, request

logger = logging.getLogger(__name__)

def return_ok(data={}) -> Response:
    content = {"status": "ok", "data": data}
    return jsonify(content)

def return_ko(data={}) -> Response:
    content = {"status": "ko", "data": data}
    return jsonify(content)

def set_auth_identifier():
    try:
        request_headers = dict(request.headers)
        auth_info = api_client().get_auth_info_from_browser_headers(request_headers)
        g.auth_identifier = auth_info["authIdentifier"]
        logger.info(f"Auth identifier set to: {g.auth_identifier}")
    except Exception as e:
        logger.warning(f"Authentication details extraction failed: {e}")
        g.auth_identifier = "unknown"

