from __future__ import annotations

from typing import List

from pydantic import BaseModel

from ..models import GraphId, VersionedGraphMetadata
from ..store.graph_metadata_store import GraphMetadataStore


class CypherQueryParams(BaseModel):
    id: str
    name: str
    query: str


class Params(BaseModel):
    graph_id: GraphId
    queries: List[CypherQueryParams]
    ref_version_token: str


def update_cypher_queries(store: GraphMetadataStore, params: Params) -> VersionedGraphMetadata:
    """
    Raises:
        GraphDoesNotExistError
        ConcurrentUpdateCollisionError
        GraphMetadataStoreError
    """
    graph_id = params.graph_id
    graph_metadata = store.get(graph_id)

    graph_metadata["cypher_queries"] = [{"id": q.id, "name": q.name, "query": q.query} for q in params.queries]

    return store.update(graph_metadata, params.ref_version_token)
