from __future__ import annotations

from pydantic import BaseModel

from ..models import GraphId, ModelValidationError, VersionedGraphMetadata
from ..store.graph_metadata_store import GraphMetadataStore


class Params(BaseModel):
    graph_id: GraphId
    graph_name: str
    ref_version_token: str


def rename_graph(store: GraphMetadataStore, params: Params) -> VersionedGraphMetadata:
    """
    Raises:
        ModelValidationError
        GraphDoesNotExistError
        ConcurrentUpdateCollisionError
        GraphMetadataStoreError
    """
    graph_metadata = store.get(params.graph_id)

    if not params.graph_name:
        raise ModelValidationError("Graph name cannot be empty.")

    graph_metadata["name"] = params.graph_name
    return store.update(graph_metadata, params.ref_version_token)
