from typing import Dict, Union

from typing_extensions import Literal

KuzuDataType = Union[
    Literal["STRING"],
    Literal["BOOLEAN"],
    Literal["TIMESTAMP"],
    Literal["INT8"],
    Literal["INT16"],
    Literal["INT32"],
    Literal["INT64"],
    Literal["FLOAT"],
    Literal["DOUBLE"],
]

DataikuDataType = Union[
    Literal["object"],
    Literal["string"],
    Literal["boolean"],
    Literal["date"],
    Literal["tinyint"],
    Literal["smallint"],
    Literal["int"],
    Literal["bigint"],
    Literal["float"],
    Literal["double"],
]
TYPE_MAPPING_DATAIKU_KUZU: Dict[DataikuDataType, KuzuDataType] = {
    "object": "STRING",
    "string": "STRING",
    "boolean": "BOOLEAN",
    "date": "TIMESTAMP",
    "tinyint": "INT8",
    "smallint": "INT16",
    "int": "INT32",
    "bigint": "INT64",
    "float": "FLOAT",
    "double": "DOUBLE",
}
