from typing import Any, Dict, Optional

from pydantic import BaseModel

from ..models import GraphId, SnapshotId


class RunCypherParams(BaseModel):
    graph_id: GraphId
    query: str
    params: Optional[Dict[str, Any]] = None


class RunLlmCypherParams(BaseModel):
    graph_id: GraphId
    query: str


class ExplorerRunCypherParams(BaseModel):
    snapshot_id: SnapshotId
    query: str
    params: Optional[Dict[str, Any]] = None


class ComputeAdjacentNodeGroupInfoParams(BaseModel):
    node_group: str
    node_id: Any
