/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.sensision.jarjar.org.eclipse.jetty.server.handler;

import io.warp10.sensision.jarjar.javax.servlet.ServletException;
import io.warp10.sensision.jarjar.javax.servlet.http.HttpServletRequest;
import io.warp10.sensision.jarjar.javax.servlet.http.HttpServletResponse;
import io.warp10.sensision.jarjar.org.eclipse.jetty.server.Handler;
import io.warp10.sensision.jarjar.org.eclipse.jetty.server.Request;
import io.warp10.sensision.jarjar.org.eclipse.jetty.server.Server;
import io.warp10.sensision.jarjar.org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import java.io.IOException;

public class HotSwapHandler
extends AbstractHandlerContainer {
    private volatile Handler _handler;

    public Handler getHandler() {
        return this._handler;
    }

    @Override
    public Handler[] getHandlers() {
        return new Handler[]{this._handler};
    }

    public void setHandler(Handler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Parameter handler is null.");
        }
        try {
            Handler old_handler = this._handler;
            this._handler = handler;
            Server server = this.getServer();
            handler.setServer(server);
            this.addBean(handler);
            if (server != null) {
                server.getContainer().update((Object)this, old_handler, handler, "handler");
            }
            if (old_handler != null) {
                this.removeBean(old_handler);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this._handler != null && this.isStarted()) {
            this._handler.handle(target, baseRequest, request, response);
        }
    }

    @Override
    public void setServer(Server server) {
        Server old_server = this.getServer();
        if (server == old_server) {
            return;
        }
        if (this.isRunning()) {
            throw new IllegalStateException("RUNNING");
        }
        super.setServer(server);
        Handler h = this.getHandler();
        if (h != null) {
            h.setServer(server);
        }
        if (server != null && server != old_server) {
            server.getContainer().update((Object)this, null, this._handler, "handler");
        }
    }

    protected Object expandChildren(Object list, Class byClass) {
        return this.expandHandler(this._handler, list, byClass);
    }

    @Override
    public void destroy() {
        if (!this.isStopped()) {
            throw new IllegalStateException("!STOPPED");
        }
        Handler child = this.getHandler();
        if (child != null) {
            this.setHandler(null);
            child.destroy();
        }
        super.destroy();
    }
}

