/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.sensision.jarjar.org.mortbay.jetty.handler;

import io.warp10.sensision.jarjar.javax.servlet.ServletException;
import io.warp10.sensision.jarjar.javax.servlet.http.HttpServletRequest;
import io.warp10.sensision.jarjar.javax.servlet.http.HttpServletResponse;
import io.warp10.sensision.jarjar.org.mortbay.io.Buffer;
import io.warp10.sensision.jarjar.org.mortbay.io.ByteArrayBuffer;
import io.warp10.sensision.jarjar.org.mortbay.io.WriterOutputStream;
import io.warp10.sensision.jarjar.org.mortbay.jetty.HttpConnection;
import io.warp10.sensision.jarjar.org.mortbay.jetty.HttpFields;
import io.warp10.sensision.jarjar.org.mortbay.jetty.HttpHeaders;
import io.warp10.sensision.jarjar.org.mortbay.jetty.MimeTypes;
import io.warp10.sensision.jarjar.org.mortbay.jetty.Request;
import io.warp10.sensision.jarjar.org.mortbay.jetty.Response;
import io.warp10.sensision.jarjar.org.mortbay.jetty.handler.AbstractHandler;
import io.warp10.sensision.jarjar.org.mortbay.jetty.handler.ContextHandler;
import io.warp10.sensision.jarjar.org.mortbay.log.Log;
import io.warp10.sensision.jarjar.org.mortbay.resource.FileResource;
import io.warp10.sensision.jarjar.org.mortbay.resource.Resource;
import io.warp10.sensision.jarjar.org.mortbay.util.TypeUtil;
import io.warp10.sensision.jarjar.org.mortbay.util.URIUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;

public class ResourceHandler
extends AbstractHandler {
    ContextHandler _context;
    Resource _baseResource;
    String[] _welcomeFiles = new String[]{"index.html"};
    MimeTypes _mimeTypes = new MimeTypes();
    ByteArrayBuffer _cacheControl;
    boolean _aliases;

    public MimeTypes getMimeTypes() {
        return this._mimeTypes;
    }

    public void setMimeTypes(MimeTypes mimeTypes) {
        this._mimeTypes = mimeTypes;
    }

    public boolean isAliases() {
        return this._aliases;
    }

    public void setAliases(boolean aliases) {
        this._aliases = aliases;
    }

    public void doStart() throws Exception {
        ContextHandler.SContext scontext = ContextHandler.getCurrentContext();
        ContextHandler contextHandler = this._context = scontext == null ? null : scontext.getContextHandler();
        if (!this._aliases && !FileResource.getCheckAliases()) {
            throw new IllegalStateException("Alias checking disabled");
        }
        super.doStart();
    }

    public Resource getBaseResource() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource;
    }

    public String getResourceBase() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource.toString();
    }

    public void setBaseResource(Resource base) {
        this._baseResource = base;
    }

    public void setResourceBase(String resourceBase) {
        try {
            this.setBaseResource(Resource.newResource(resourceBase));
        }
        catch (Exception e) {
            Log.warn(e.toString());
            Log.debug(e);
            throw new IllegalArgumentException(resourceBase);
        }
    }

    public String getCacheControl() {
        return this._cacheControl.toString();
    }

    public void setCacheControl(String cacheControl) {
        this._cacheControl = cacheControl == null ? null : new ByteArrayBuffer(cacheControl);
    }

    public Resource getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException(path);
        }
        Resource base = this._baseResource;
        if (base == null) {
            if (this._context == null) {
                return null;
            }
            base = this._context.getBaseResource();
            if (base == null) {
                return null;
            }
        }
        try {
            path = URIUtil.canonicalPath(path);
            Resource resource = base.addPath(path);
            return resource;
        }
        catch (Exception e) {
            Log.ignore(e);
            return null;
        }
    }

    protected Resource getResource(HttpServletRequest request) throws MalformedURLException {
        String path_info = request.getPathInfo();
        if (path_info == null) {
            return null;
        }
        return this.getResource(path_info);
    }

    public String[] getWelcomeFiles() {
        return this._welcomeFiles;
    }

    public void setWelcomeFiles(String[] welcomeFiles) {
        this._welcomeFiles = welcomeFiles;
    }

    protected Resource getWelcome(Resource directory) throws MalformedURLException, IOException {
        for (int i = 0; i < this._welcomeFiles.length; ++i) {
            Resource welcome = directory.addPath(this._welcomeFiles[i]);
            if (!welcome.exists() || welcome.isDirectory()) continue;
            return welcome;
        }
        return null;
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        long if_modified;
        long last_modified;
        Resource resource;
        Request base_request;
        Request request2 = base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        if (base_request.isHandled()) {
            return;
        }
        boolean skipContentBody = false;
        if (!"GET".equals(request.getMethod())) {
            if (!"HEAD".equals(request.getMethod())) {
                return;
            }
            skipContentBody = true;
        }
        if ((resource = this.getResource(request)) == null || !resource.exists()) {
            return;
        }
        if (!this._aliases && resource.getAlias() != null) {
            Log.info(resource + " aliased to " + resource.getAlias());
            return;
        }
        base_request.setHandled(true);
        if (resource.isDirectory()) {
            if (!request.getPathInfo().endsWith("/")) {
                response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths(request.getRequestURI(), "/")));
                return;
            }
            if ((resource = this.getWelcome(resource)) == null || !resource.exists() || resource.isDirectory()) {
                response.sendError(403);
                return;
            }
        }
        if ((last_modified = resource.lastModified()) > 0L && (if_modified = request.getDateHeader("If-Modified-Since")) > 0L && last_modified / 1000L <= if_modified / 1000L) {
            response.setStatus(304);
            return;
        }
        Buffer mime = this._mimeTypes.getMimeByExtension(resource.toString());
        if (mime == null) {
            mime = this._mimeTypes.getMimeByExtension(request.getPathInfo());
        }
        this.doResponseHeaders(response, resource, mime != null ? mime.toString() : null);
        response.setDateHeader("Last-Modified", last_modified);
        if (skipContentBody) {
            return;
        }
        OutputStream out = null;
        try {
            out = response.getOutputStream();
        }
        catch (IllegalStateException e) {
            out = new WriterOutputStream(response.getWriter());
        }
        if (out instanceof HttpConnection.Output) {
            ((HttpConnection.Output)out).sendContent(resource.getInputStream());
        } else {
            resource.writeTo(out, 0L, resource.length());
        }
    }

    protected void doResponseHeaders(HttpServletResponse response, Resource resource, String mimeType) {
        if (mimeType != null) {
            response.setContentType(mimeType);
        }
        long length = resource.length();
        if (response instanceof Response) {
            HttpFields fields = ((Response)response).getHttpFields();
            if (length > 0L) {
                fields.putLongField(HttpHeaders.CONTENT_LENGTH_BUFFER, length);
            }
            if (this._cacheControl != null) {
                fields.put(HttpHeaders.CACHE_CONTROL_BUFFER, this._cacheControl);
            }
        } else {
            if (length > 0L) {
                response.setHeader("Content-Length", TypeUtil.toString(length));
            }
            if (this._cacheControl != null) {
                response.setHeader("Cache-Control", this._cacheControl.toString());
            }
        }
    }
}

