/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.geo;

import com.geoxp.geo.HHCodeHelper;
import gnu.trove.decorator.TLongSetDecorator;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Coverage {
    public static long[] PREFIX_MASK;
    public static long[] CENTER_BITS;
    public static long[] CELL_SIZE_BY_RES;
    private static final String HEXDIGITS = "0123456789abcdef";
    public static final int MAX_RES_DIFF = 4;
    private Set<Long>[] coverage = new Set[16];
    private Set<Integer> resolutions = new HashSet<Integer>();
    private long autoThresholds = 0L;
    private boolean autoOptimize = false;
    private boolean autoDedup = false;
    private boolean useTrove = false;

    public Coverage() {
    }

    public Coverage(long[] lArray) {
        for (int i = 0; i < lArray.length; ++i) {
            int n = (int)(lArray[i] >>> 60 & 0xFL) - 1;
            if (null == this.coverage[n]) {
                this.coverage[n] = this.allocateCellHashSet();
            }
            this.coverage[n].add(lArray[i] << 4);
        }
    }

    public Coverage(Map<Integer, Set<Long>> map) {
        for (int i = 0; i < 32; ++i) {
            int n = (i >> 1) - 1;
            if (!map.containsKey(i)) continue;
            this.coverage[n] = this.allocateCellHashSet();
            this.coverage[n].addAll((Collection<Long>)map.get(i));
        }
    }

    public Set<Integer> getResolutions() {
        this.resolutions.clear();
        for (int i = 0; i < 16; ++i) {
            if (null == this.coverage[i] || this.coverage[i].isEmpty()) continue;
            this.resolutions.add(i + 1 << 1);
        }
        return this.resolutions;
    }

    public Map<Integer, Integer> getCardinalities() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < 16; ++i) {
            if (null == this.coverage[i] || !this.coverage[i].isEmpty()) continue;
            hashMap.put(i + 1 << 1, this.coverage[i].size());
        }
        return hashMap;
    }

    public int getCellCount(int n) {
        int n2 = (n >> 1) - 1;
        if (0 != (n2 & 0xFFFFFFF0)) {
            return 0;
        }
        return this.internalGetCells(n2).size();
    }

    public int getCellCount() {
        int n = 0;
        for (int i = 0; i < 16; ++i) {
            if (null == this.coverage[i]) continue;
            n += this.coverage[i].size();
        }
        return n;
    }

    public Set<Long> getCells(int n) {
        int n2 = (n >> 1) - 1;
        if (0 != (n2 & 0xFFFFFFF0)) {
            return null;
        }
        return this.internalGetCells(n2);
    }

    public Map<Integer, Set<Long>> getAllCells() {
        HashMap<Integer, Set<Long>> hashMap = new HashMap<Integer, Set<Long>>();
        for (int i = 0; i < 16; ++i) {
            if (null == this.coverage[i] || this.coverage[i].isEmpty()) continue;
            Set<Long> set = this.allocateCellHashSet();
            set.addAll(this.coverage[i]);
            hashMap.put(i + 1 << 1, set);
        }
        return hashMap;
    }

    private Set<Long> internalGetCells(int n) {
        if (null == this.coverage[n]) {
            this.coverage[n] = this.allocateCellHashSet();
        }
        return this.coverage[n];
    }

    public void addCell(int n, long l, long l2, long[] lArray, boolean bl) {
        l = (l % 0x100000000L + 0x100000000L) % 0x100000000L;
        l2 = (l2 % 0x100000000L + 0x100000000L) % 0x100000000L;
        this.addCell(n, HHCodeHelper.buildHHCode(l, l2, 32), lArray, bl);
    }

    public void addCell(int n, long l, long l2) {
        this.addCell(n, l, l2, null, false);
    }

    public void addCell(int n, long l, long[] lArray, boolean bl) {
        int n2;
        int n3 = (n >> 1) - 1;
        if (0 != (n3 & 0xFFFFFFF0)) {
            return;
        }
        if (null != lArray && ((n2 = Coverage.contains(lArray, l &= PREFIX_MASK[n3], 2, n)) != 0 && bl || n2 == 0 && !bl)) {
            return;
        }
        if (this.autoDedup) {
            if (n3 > 10) {
                for (n2 = n3 - 1; n2 >= 0; --n2) {
                    if (!this.internalGetCells(n2).contains(l & PREFIX_MASK[n2])) continue;
                    return;
                }
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (!this.internalGetCells(n2).contains(l & PREFIX_MASK[n2])) continue;
                    return;
                }
            }
        }
        this.internalGetCells(n3).add(l);
        if (this.autoOptimize) {
            while (this.optimizeCell(l, n, this.autoThresholds)) {
                n -= 2;
            }
        }
    }

    public boolean optimizeCell(long l, int n, long l2) {
        long l3;
        long l4;
        if (2 == n) {
            return false;
        }
        int n2 = (n >> 1) - 1;
        if (this.internalGetCells(n2).isEmpty()) {
            return false;
        }
        long l5 = l2 >> 4 * (15 - n2) & 0xFL;
        if (0L == l5) {
            l5 = 16L;
        }
        if ((long)this.internalGetCells(n2).size() < l5) {
            return false;
        }
        int n3 = 0;
        long l6 = l & PREFIX_MASK[n2 - 1];
        for (l4 = 0L; l4 < 16L; ++l4) {
            l3 = l6 | l4 << 4 * (15 - n2);
            if (this.internalGetCells(n2).contains(l3) && (long)(++n3) >= l5) break;
        }
        if ((long)n3 >= l5) {
            this.internalGetCells(n2 - 1).add(l6);
            for (l4 = 0L; l4 < 16L; ++l4) {
                l3 = l6 | l4 << 4 * (15 - n2);
                this.internalGetCells(n2).remove(l3);
            }
            return true;
        }
        return false;
    }

    public void addCell(int n, long l) {
        this.addCell(n, l, null, false);
    }

    public boolean contains(int n, long l) {
        int n2 = (n >> 1) - 1;
        if (0 != (n2 & 0xFFFFFFF0)) {
            return false;
        }
        return !this.internalGetCells(n2).isEmpty() && this.internalGetCells(n2).contains(l & PREFIX_MASK[n2]);
    }

    public void removeCell(int n, long l) {
        int n2 = (n >> 1) - 1;
        if (0 != (n2 & 0xFFFFFFF0)) {
            return;
        }
        this.internalGetCells(n2).remove(l & PREFIX_MASK[n2]);
    }

    public String toString(String string) {
        return this.toString(string, "");
    }

    public String toString(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            if (null == this.coverage[i]) continue;
            for (long l : this.coverage[i]) {
                stringBuilder2.setLength(0);
                stringBuilder2.append(Long.toHexString(l));
                while (stringBuilder2.length() < 16) {
                    stringBuilder2.insert(0, "0");
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(string2);
                stringBuilder.append(stringBuilder2.subSequence(0, i + 1));
            }
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toString(" ");
    }

    public long[] toGeoCells(int n) {
        if (n > 30) {
            n = 30;
        }
        int n2 = 0;
        for (int i = 0; i < n >> 1; ++i) {
            if (null == this.coverage[i]) continue;
            n2 += this.coverage[i].size();
        }
        long[] lArray = new long[n2];
        int n3 = 0;
        for (int i = 0; i < n >> 1; ++i) {
            if (null == this.coverage[i] || this.coverage[i].isEmpty()) continue;
            for (Long l : this.coverage[i]) {
                lArray[n3] = (long)(i + 1) << 60;
                int n4 = n3++;
                lArray[n4] = lArray[n4] | l >> 4 & 0xFFFFFFFFFFFFFFFL;
            }
        }
        Arrays.sort(lArray);
        return lArray;
    }

    public static boolean contains(long[] lArray, int n, long l) {
        long l2 = (long)(n >> 1) << 60;
        long l3 = -1L << 60 - (n << 1);
        l3 &= 0xFFFFFFFFFFFFFFFL;
        long l4 = l >> 4 & 0xFFFFFFFFFFFFFFFL & (l3 |= l2) | l2;
        int n2 = Arrays.binarySearch(lArray, l4);
        return n2 >= 0;
    }

    public static boolean contains(long[] lArray, long l) {
        for (int i = 2; i < 32; i += 2) {
            if (!Coverage.contains(lArray, i, l)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(long[] lArray, long l, int n, int n2) {
        if (n < 2) {
            n = 2;
        }
        if (n2 > 30) {
            n2 = 30;
        }
        for (int i = n; i <= n2; i += 2) {
            if (!Coverage.contains(lArray, i, l)) continue;
            return true;
        }
        return false;
    }

    public Coverage optimize(long l, int n, int n2, int n3) {
        long l2;
        Long[] longArray;
        int n4;
        n2 = (n2 >> 1) - 1;
        n = (n >> 1) - 1;
        if (n2 > 15) {
            n2 = 15;
        }
        int n5 = 0;
        if (0 != n3 && (n5 = this.getCellCount()) <= n3) {
            return this;
        }
        for (n4 = n2; n4 > n; --n4) {
            if (null == this.coverage[n4]) continue;
            long l3 = l >> 4 * (15 - n4) & 0xFL;
            longArray = new ArrayList();
            longArray.addAll(this.coverage[n4]);
            Collections.sort(longArray);
            boolean bl = true;
            long l4 = 0L;
            l2 = 0L;
            int n6 = 0;
            int n7 = longArray.size();
            Object object = longArray.iterator();
            while (object.hasNext()) {
                long l5 = (Long)object.next();
                --n7;
                l4 = l5 & PREFIX_MASK[n4 - 1];
                if (bl) {
                    l2 = l4;
                    n6 = 0;
                }
                bl = false;
                if (l2 != l4 || 0 == n7) {
                    if (0 == n7) {
                        ++n6;
                    }
                    if (l3 > 0L && (long)n6 >= l3 || n6 == 16) {
                        this.internalGetCells(n4 - 1).add(l2);
                        ++n5;
                        n5 -= 0L == l3 ? 16 : (0 == n7 ? n6 : n6 - 1);
                        Set<Long> set = this.internalGetCells(n4);
                        int n8 = set.size();
                        for (long i = 0L; i < 16L; ++i) {
                            set.remove(l2 | i << 4 * (15 - n4));
                        }
                        if (n3 > 0 && n5 <= n3) break;
                    }
                    if (0 != n7) {
                        l2 = l4;
                    }
                    n6 = 1;
                    continue;
                }
                ++n6;
            }
            if (l2 != l4 && (0 == n3 || n3 > 0 && n5 <= n3) && (l3 > 0L && (long)n6 >= l3 || n6 == 16)) {
                this.internalGetCells(n4 - 1).add(l4);
                ++n5;
                n5 -= 0L == l3 ? 16 : (0 == n7 ? n6 : n6 - 1);
                object = this.internalGetCells(n4);
                int n9 = object.size();
                for (long i = 0L; i < 16L; ++i) {
                    object.remove(l4 | i << 4 * (15 - n4));
                }
            }
            if (n3 > 0 && n5 <= n3) break;
        }
        for (n4 = 0; n4 < 14; ++n4) {
            Set<Long> set = this.internalGetCells(n4);
            Set<Long> set2 = this.internalGetCells(n4 + 2);
            if (set.isEmpty() || set2.isEmpty()) continue;
            Long[] longArray2 = longArray = set2.toArray(new Long[0]);
            int n10 = longArray2.length;
            for (int i = 0; i < n10; ++i) {
                l2 = longArray2[i];
                if (!set.contains(l2 & PREFIX_MASK[n4])) continue;
                set2.remove(l2);
            }
        }
        return this;
    }

    public void optimize(long l) {
        this.optimize(l, 2, 32, 0);
    }

    public void optimize(long l, int n) {
        this.optimize(l, n, 32, 0);
    }

    public void dedup() {
        for (int i = 15; i >= 0; --i) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            arrayList.addAll(this.internalGetCells(i));
            Iterator iterator = arrayList.iterator();
            block1: while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                for (int j = 0; j < i; ++j) {
                    if (!this.internalGetCells(j).contains(l & PREFIX_MASK[j])) continue;
                    this.internalGetCells(i).remove(l);
                    continue block1;
                }
            }
        }
    }

    public Coverage prune(long l, int n, int n2) {
        n = (n >> 1) - 1;
        int n3 = 0;
        if (0 != n2 && (n3 = this.getCellCount()) <= n2) {
            return this;
        }
        for (int i = 15; i > n; --i) {
            if (null == this.coverage[i]) continue;
            long l2 = l >> 4 * (15 - i) & 0xFL;
            ArrayList<Long> arrayList = new ArrayList<Long>();
            arrayList.addAll(this.coverage[i]);
            Collections.sort(arrayList);
            boolean bl = true;
            long l3 = 0L;
            long l4 = 0L;
            int n4 = 0;
            int n5 = arrayList.size();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                long l5 = (Long)iterator.next();
                --n5;
                l3 = l5 & PREFIX_MASK[i - 1];
                if (bl) {
                    l4 = l3;
                    n4 = 0;
                }
                bl = false;
                if (l4 != l3 || 0 == n5) {
                    if (0 == n5) {
                        ++n4;
                    }
                    if ((long)n4 <= l2) {
                        n3 -= n4;
                        Set<Long> set = this.internalGetCells(i);
                        int n6 = set.size();
                        for (long j = 0L; j < 16L; ++j) {
                            set.remove(l4 | j << 4 * (15 - i));
                        }
                        if (n2 > 0 && n3 <= n2) break;
                    }
                    l4 = l3;
                    n4 = 1;
                    continue;
                }
                ++n4;
            }
            if (n2 > 0 && n3 <= n2) break;
        }
        return this;
    }

    public void merge(Coverage coverage) {
        for (int i = 0; i < 16; ++i) {
            Set<Long> set = this.internalGetCells(i);
            Set<Long> set2 = coverage.internalGetCells(i);
            set.addAll(set2);
        }
        this.resolutions.addAll(coverage.getResolutions());
    }

    public long area() {
        long l = 0L;
        for (int i = 0; i < 16; ++i) {
            if (null == this.coverage[i]) continue;
            l += (long)this.coverage[i].size() * (1L << 60 - 4 * i);
        }
        return l >> 1 & Long.MAX_VALUE;
    }

    public int getCoarsestResolution(long l) {
        for (int i = 0; i < 16; ++i) {
            if (null == this.coverage[i] || !this.coverage[i].contains(l & PREFIX_MASK[i])) continue;
            return i + 1 << 1;
        }
        return 0;
    }

    public int getFinestResolution(long l) {
        for (int i = 15; i >= 0; --i) {
            if (null == this.coverage[i] || !this.coverage[i].contains(l & PREFIX_MASK[i])) continue;
            return i + 1 << 1;
        }
        return 0;
    }

    public int getFinestResolution() {
        for (int i = 15; i >= 0; --i) {
            if (null == this.coverage[i] || this.coverage[i].isEmpty()) continue;
            return i + 1 << 1;
        }
        return 0;
    }

    public void normalize(int n) {
        n = (n >> 1) - 1;
        for (int i = 0; i < n; ++i) {
            Set<Long> set = this.internalGetCells(i);
            if (set.isEmpty()) continue;
            long l = 1 << 4 * (n - i);
            for (long j = 0L; j < l; ++j) {
                long l2 = j << 4 * (15 - n);
                for (long l3 : set) {
                    this.internalGetCells(n).add((l3 | l2) & PREFIX_MASK[n]);
                }
            }
            set.clear();
            this.resolutions.remove(i + 1 << 1);
        }
        this.resolutions.add(n + 1 << 1);
        long l = 0x111111111111111L >> 4 * n;
        this.optimize(l, n + 1 << 1);
    }

    public Coverage deepCopy() {
        Coverage coverage = new Coverage();
        coverage.resolutions.addAll(this.resolutions);
        for (int i = 0; i < 16; ++i) {
            if (null == this.coverage[i] || this.coverage[i].isEmpty()) continue;
            coverage.coverage[i] = this.allocateCellHashSet();
            coverage.coverage[i].addAll(this.coverage[i]);
        }
        return coverage;
    }

    public int getMeanResolution() {
        long l = this.getCellCount();
        if (0L == l) {
            return 0;
        }
        long l2 = this.area() / l << 1;
        if (0L == l2) {
            return 32;
        }
        return (int)(64.0 - Math.log(l2) / Math.log(2.0)) >> 1 & 0x3E;
    }

    public static Coverage minus_normalize(Coverage coverage, Coverage coverage2) {
        int n;
        coverage = coverage.deepCopy();
        coverage2 = coverage2.deepCopy();
        int n2 = coverage.getMeanResolution();
        int n3 = n = coverage2.getMeanResolution();
        if (n < n2 || n - n2 > 4) {
            n3 = n2 + 4;
        }
        coverage.normalize(n3);
        coverage2.normalize(n3);
        for (long l : coverage2.getCells(n3)) {
            coverage.removeCell(n3, l);
        }
        return coverage;
    }

    public static Coverage minus(Coverage coverage, Coverage coverage2, boolean bl) {
        if (bl) {
            coverage = coverage.deepCopy();
            coverage2 = coverage2.deepCopy();
        }
        coverage.optimize(0L);
        coverage2.optimize(0L);
        Coverage.normalize(coverage, coverage2);
        for (int i = 2; i <= 32; i += 2) {
            for (long l : coverage2.getCells(i)) {
                coverage.removeCell(i, l);
            }
        }
        return coverage;
    }

    public static Coverage minus(Coverage coverage, Coverage coverage2) {
        return Coverage.minus(coverage, coverage2, true);
    }

    public static Coverage intersection_normalize(Coverage coverage, Coverage coverage2) {
        if (0 == coverage.getCellCount() || 0 == coverage2.getCellCount()) {
            return new Coverage();
        }
        coverage = coverage.deepCopy();
        coverage2 = coverage2.deepCopy();
        int n = coverage.getMeanResolution();
        int n2 = coverage2.getMeanResolution();
        int n3 = 0;
        n3 = Math.abs(n - n2) > 4 ? Math.min(n, n2) + 4 : Math.max(n, n2);
        coverage.normalize(n3);
        coverage2.normalize(n3);
        Set<Long> set = coverage.getCells(n3);
        Set<Long> set2 = coverage2.getCells(n3);
        Coverage coverage3 = new Coverage();
        if (set.size() < set2.size()) {
            for (long l : set) {
                if (!set2.contains(l)) continue;
                coverage3.addCell(n3, l);
            }
        } else {
            for (long l : set2) {
                if (!set.contains(l)) continue;
                coverage3.addCell(n3, l);
            }
        }
        return coverage3;
    }

    public static Coverage intersection(Coverage coverage, Coverage coverage2, boolean bl) {
        if (0 == coverage.getCellCount() || 0 == coverage2.getCellCount()) {
            return new Coverage();
        }
        if (bl) {
            coverage = coverage.deepCopy();
            coverage2 = coverage2.deepCopy();
        }
        coverage.optimize(0L);
        coverage2.optimize(0L);
        Coverage.normalize(coverage, coverage2);
        Coverage coverage3 = new Coverage();
        for (int i = 2; i <= 32; i += 2) {
            Set<Long> set = coverage.getCells(i);
            Set<Long> set2 = coverage2.getCells(i);
            if (set.size() < set2.size()) {
                for (long l : set) {
                    if (!set2.contains(l)) continue;
                    coverage3.addCell(i, l);
                }
                continue;
            }
            for (long l : set2) {
                if (!set.contains(l)) continue;
                coverage3.addCell(i, l);
            }
        }
        return coverage3;
    }

    public static Coverage intersection(Coverage coverage, Coverage coverage2) {
        return Coverage.intersection(coverage, coverage2, true);
    }

    public void reduce(int n) {
        long l = 0L;
        this.optimize(0L, 2, 32, n);
        if (this.getCellCount() <= n) {
            return;
        }
        int n2 = this.getFinestResolution();
        long l2 = 15L;
        while (this.getCellCount() > n || this.getCellCount(2) == this.getCellCount()) {
            l = l2 << 64 - 2 * n2;
            this.optimize(l, n2 - 2, 32, n);
            if (0L != --l2) continue;
            l2 = 15L;
            while (0 == this.getCellCount(n2 -= 2) && n2 > 0) {
            }
        }
    }

    public boolean includes(long l) {
        for (int i = 0; i < 15; ++i) {
            if (null == this.coverage[i] || this.coverage[i].isEmpty() || !this.coverage[i].contains(l & PREFIX_MASK[i])) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.resolutions.clear();
        for (int i = 0; i < this.coverage.length; ++i) {
            this.coverage[i] = null;
        }
    }

    public void splitTo(int n, long l) {
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < 16; ++n2) {
            if (null != this.coverage[n2] && this.coverage[n2].contains(l & PREFIX_MASK[n2])) {
                n3 = n2;
                break;
            }
            if (n2 + 1 << 1 == n) break;
        }
        if (-1 == n3 || n == n3 + 1 << 1) {
            return;
        }
        this.coverage[n3].remove(l & PREFIX_MASK[n3]);
        if (null == this.coverage[n3 + 1]) {
            this.coverage[n3 + 1] = this.allocateCellHashSet();
        }
        for (n2 = 0; n2 < 16; ++n2) {
            long l2 = (l & PREFIX_MASK[n3] | (long)n2 << 60 - 4 * (n3 + 1)) & PREFIX_MASK[n3 + 1];
            this.coverage[n3 + 1].add(l2);
        }
        this.splitTo(n, l);
    }

    public static void normalize(Coverage coverage, Coverage coverage2) {
        for (int i = 0; i < 16; ++i) {
            if (null != coverage.coverage[i]) {
                for (long l : coverage.coverage[i]) {
                    coverage2.splitTo(i + 1 << 1, l);
                }
            }
            if (null == coverage2.coverage[i]) continue;
            for (long l : coverage2.coverage[i]) {
                coverage.splitTo(i + 1 << 1, l);
            }
        }
    }

    public void setAutoThresholds(long l) {
        this.autoThresholds = l;
        this.autoOptimize = true;
    }

    public void setAutoOptimize(boolean bl) {
        this.autoOptimize = bl;
    }

    public void setAutoDedup(boolean bl) {
        this.autoDedup = bl;
    }

    public void setUseTrove(boolean bl) {
        this.useTrove = bl;
    }

    private Set<Long> allocateCellHashSet() {
        if (this.useTrove) {
            return new TLongSetDecorator((TLongSet)new TLongHashSet());
        }
        return new HashSet<Long>();
    }

    static {
        int n;
        PREFIX_MASK = new long[16];
        CENTER_BITS = new long[16];
        CELL_SIZE_BY_RES = new long[16];
        for (n = 0; n < 16; ++n) {
            Coverage.PREFIX_MASK[n] = -1L << 60 - n * 4;
        }
        Coverage.CENTER_BITS[0] = -4611686018427387904L;
        for (n = 1; n < 16; ++n) {
            Coverage.CENTER_BITS[n] = CENTER_BITS[n - 1] >>> 4;
        }
        for (n = 0; n < 16; ++n) {
            Coverage.CELL_SIZE_BY_RES[n] = 1L << 32 - (n + 1 << 1);
        }
    }
}

