/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.geo;

import com.geoxp.geo.HHCodeHelper;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Random;
import sun.misc.Unsafe;

public class GeoBloomFilter {
    private static final int K = 100;
    private static final int MAX_GEN = 6;
    private static final int[] DEFAULT_OFFSETS = new int[6];
    private static final int[] DEFAULT_LIMITS = new int[6];
    private static final int[] DEFAULT_LENGTHS = new int[6];
    private long known;
    private static final long[] hashkeys;
    private final int[] offsets;
    private final int[] limits;
    private final int[] lengths;
    private static final Unsafe UNSAFE;
    private static final long base;
    private int generation = 0;
    private int k = 6;
    private final boolean slice;
    private final BitSet bits;
    private long[] counts = new long[]{0L};
    private final byte[] data = new byte[8];
    private final int maxres;
    private final long resolutionMask;

    private void init(int[] nArray, double[] dArray) {
        if (nArray.length != dArray.length || nArray.length > 6 || dArray.length > 6) {
            throw new RuntimeException("Invalid n/p arrays, max size is 6");
        }
        int n = 272;
        for (int i = 0; i < nArray.length; ++i) {
            this.offsets[i] = n;
            this.lengths[i] = (int)Math.ceil((double)(-nArray[i]) * Math.log(dArray[i]) / (Math.log(2.0) * Math.log(2.0)));
            this.limits[i] = nArray[i];
            n += nArray[i];
        }
    }

    public GeoBloomFilter(int n, int[] nArray, double[] dArray, int n2, boolean bl) {
        if (n < 1 || n > 15) {
            throw new RuntimeException("Invalid resolution, MUST be between 1 and 15, both inclusive.");
        }
        if (n2 > hashkeys.length / 2) {
            throw new RuntimeException("k cannot be greater than " + hashkeys.length / 2);
        }
        this.slice = bl;
        this.k = n2;
        if (n2 > 32 && bl) {
            throw new RuntimeException("slicing can only be used when k <= 32.");
        }
        this.maxres = n;
        this.resolutionMask = 0xFFFFFFFFFFFFFFFL << 60 - n * 4;
        if (null != nArray && null != dArray) {
            this.offsets = new int[nArray.length];
            this.limits = new int[nArray.length];
            this.lengths = new int[nArray.length];
            this.init(nArray, dArray);
        } else {
            this.offsets = DEFAULT_OFFSETS;
            this.limits = DEFAULT_LIMITS;
            this.lengths = DEFAULT_LENGTHS;
        }
        this.bits = new BitSet(272 + this.lengths[0]);
    }

    public long fixCell(long l) {
        int n = (int)(l >>> 60 & 0xFL);
        if (n > this.maxres) {
            l &= 0xFFFFFFFFFFFFFFFL;
            l |= ((long)this.maxres & 0xFL) << 60 & 0xF000000000000000L;
            l &= this.resolutionMask;
        }
        return l;
    }

    public synchronized void add(long l) {
        int n = (int)(l >>> 56);
        this.bits.set(16 + n);
        int n2 = (n & 0xF0) >>> 4;
        this.bits.set(n2);
        if (0L == (l & 0xFFFFFFFFFFFFFFL)) {
            return;
        }
        for (int i = 0; i < this.maxres; ++i) {
            int n3;
            long l2 = (long)(i + 1) << 60;
            l2 |= l >> 4 & 0xFFFFFFFFFFFFFFFL;
            l2 &= 0xFFFFFFFFFFFFFFFFL ^ (1L << 4 * (15 - (i + 1))) - 1L;
            for (n3 = 0; n3 < 8; ++n3) {
                this.data[7 - n3] = (byte)(l2 & 0xFFL);
                l2 >>>= 8;
            }
            n3 = 1;
            if (this.slice) {
                long l3 = GeoBloomFilter.hash24(hashkeys[0], hashkeys[1], this.data, 0, this.data.length);
                for (int j = 0; j < this.k; ++j) {
                    long l4 = l3 >>> j & 0xFFFFFFFFL;
                    if (n3 != 0 && this.bits.get(this.offsets[this.generation] + (int)(l4 % (long)this.lengths[this.generation]))) continue;
                    this.bits.set(this.offsets[this.generation] + (int)(l4 % (long)this.lengths[this.generation]));
                    n3 = 0;
                }
            } else {
                for (int j = 0; j < this.k * 2; j += 2) {
                    long l5 = GeoBloomFilter.hash24(hashkeys[j], hashkeys[j + 1], this.data, 0, this.data.length) & 0xFFFFFFFFL;
                    if (n3 != 0 && this.bits.get(this.offsets[this.generation] + (int)(l5 % (long)this.lengths[this.generation]))) continue;
                    this.bits.set(this.offsets[this.generation] + (int)(l5 % (long)this.lengths[this.generation]));
                    n3 = 0;
                }
            }
            if (n3 != 0) continue;
            int n4 = this.generation;
            this.counts[n4] = this.counts[n4] + 1L;
            if (this.counts[this.generation] < (long)this.limits[this.generation] || this.generation >= 5) continue;
            ++this.generation;
            this.counts = Arrays.copyOf(this.counts, this.counts.length + 1);
        }
    }

    public boolean contains(long l) {
        int n = (int)((l & 0xFF0000000000000L) >>> 52);
        int n2 = (n & 0xF0) >>> 4;
        int n3 = (int)(l >>> 60 & 0xFL);
        if (0 == n3) {
            return false;
        }
        if (!this.bits.get(n2)) {
            return false;
        }
        if (1 == n3) {
            return true;
        }
        if (!this.bits.get(16 + n)) {
            return false;
        }
        if (2 == n3) {
            return true;
        }
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[7 - i] = (byte)(l & 0xFFL);
            l >>>= 8;
        }
        long l2 = (1L << this.generation + 1) - 1L;
        if (this.slice) {
            long l3 = GeoBloomFilter.hash24(hashkeys[0], hashkeys[1], byArray, 0, byArray.length);
            for (int i = 0; i < this.k; ++i) {
                long l4 = l3 >>> i & 0xFFFFFFFFL;
                for (int j = 0; j <= this.generation; ++j) {
                    if (this.bits.get(this.offsets[j] + (int)((l4 & 0xFFFFFFFFL) % (long)this.lengths[j])) || 0L != (l2 &= 0xFFFFFFFFFFFFFFFFL ^ 1L << j)) continue;
                    return false;
                }
            }
        } else {
            for (int i = 0; i < this.k * 2; i += 2) {
                long l5 = GeoBloomFilter.hash24(hashkeys[i], hashkeys[i + 1], byArray, 0, byArray.length);
                for (int j = 0; j <= this.generation; ++j) {
                    if (this.bits.get(this.offsets[j] + (int)((l5 & 0xFFFFFFFFL) % (long)this.lengths[j])) || 0L != (l2 &= 0xFFFFFFFFFFFFFFFFL ^ 1L << j)) continue;
                    return false;
                }
            }
        }
        return 0L != l2;
    }

    public boolean containsHierarchy(long l) {
        while (0L != l && this.contains(l)) {
            l = HHCodeHelper.parentGeoCell(l);
        }
        return 0L == l;
    }

    public long[] getKeys() {
        return hashkeys;
    }

    public long size() {
        return this.bits.size() / 8;
    }

    private static long hash24(long l, long l2, byte[] byArray, int n, int n2) {
        long l3;
        long l4 = 0x736F6D6570736575L ^ l;
        long l5 = 0x646F72616E646F6DL ^ l2;
        long l6 = 0x6C7967656E657261L ^ l;
        long l7 = 0x7465646279746573L ^ l2;
        int n3 = n2 / 8 * 8;
        int n4 = 0;
        while (n4 < n3) {
            l3 = UNSAFE.getLong(byArray, base + (long)n + (long)n4);
            n4 += 8;
            l4 += l5;
            l6 += (l7 ^= l3);
            l5 = l5 << 13 | l5 >>> 51;
            l7 = l7 << 16 | l7 >>> 48;
            l5 ^= l4;
            l7 ^= l6;
            l4 = l4 << 32 | l4 >>> 32;
            l6 += l5;
            l4 += l7;
            l5 = l5 << 17 | l5 >>> 47;
            l7 = l7 << 21 | l7 >>> 43;
            l5 ^= l6;
            l7 ^= l4;
            l6 = l6 << 32 | l6 >>> 32;
            l4 += l5;
            l6 += l7;
            l5 = l5 << 13 | l5 >>> 51;
            l7 = l7 << 16 | l7 >>> 48;
            l5 ^= l4;
            l7 ^= l6;
            l4 = l4 << 32 | l4 >>> 32;
            l6 += l5;
            l4 += l7;
            l5 = l5 << 17 | l5 >>> 47;
            l7 = l7 << 21 | l7 >>> 43;
            l5 ^= l6;
            l7 ^= l4;
            l6 = l6 << 32 | l6 >>> 32;
            l4 ^= l3;
        }
        l3 = 0L;
        for (n4 = n2 - 1; n4 >= n3; --n4) {
            l3 <<= 8;
            l3 |= (long)byArray[n + n4] & 0xFFL;
        }
        l4 += l5;
        l6 += (l7 ^= (l3 |= (long)n2 << 56));
        l5 = l5 << 13 | l5 >>> 51;
        l7 = l7 << 16 | l7 >>> 48;
        l5 ^= l4;
        l7 ^= l6;
        l4 = l4 << 32 | l4 >>> 32;
        l6 += l5;
        l4 += l7;
        l5 = l5 << 17 | l5 >>> 47;
        l7 = l7 << 21 | l7 >>> 43;
        l5 ^= l6;
        l7 ^= l4;
        l6 = l6 << 32 | l6 >>> 32;
        l4 += l5;
        l6 += l7;
        l5 = l5 << 13 | l5 >>> 51;
        l7 = l7 << 16 | l7 >>> 48;
        l5 ^= l4;
        l7 ^= l6;
        l4 = l4 << 32 | l4 >>> 32;
        l6 += l5;
        l4 += l7;
        l5 = l5 << 17 | l5 >>> 47;
        l7 = l7 << 21 | l7 >>> 43;
        l5 ^= l6;
        l7 ^= l4;
        l6 = l6 << 32 | l6 >>> 32;
        l4 ^= l3;
        l6 ^= 0xFFL;
        l4 += l5;
        l6 += l7;
        l5 = l5 << 13 | l5 >>> 51;
        l7 = l7 << 16 | l7 >>> 48;
        l5 ^= l4;
        l7 ^= l6;
        l4 = l4 << 32 | l4 >>> 32;
        l6 += l5;
        l4 += l7;
        l5 = l5 << 17 | l5 >>> 47;
        l7 = l7 << 21 | l7 >>> 43;
        l5 ^= l6;
        l7 ^= l4;
        l6 = l6 << 32 | l6 >>> 32;
        l4 += l5;
        l6 += l7;
        l5 = l5 << 13 | l5 >>> 51;
        l7 = l7 << 16 | l7 >>> 48;
        l5 ^= l4;
        l7 ^= l6;
        l4 = l4 << 32 | l4 >>> 32;
        l6 += l5;
        l4 += l7;
        l5 = l5 << 17 | l5 >>> 47;
        l7 = l7 << 21 | l7 >>> 43;
        l5 ^= l6;
        l7 ^= l4;
        l6 = l6 << 32 | l6 >>> 32;
        l4 += l5;
        l6 += l7;
        l5 = l5 << 13 | l5 >>> 51;
        l7 = l7 << 16 | l7 >>> 48;
        l5 ^= l4;
        l7 ^= l6;
        l4 = l4 << 32 | l4 >>> 32;
        l6 += l5;
        l4 += l7;
        l5 = l5 << 17 | l5 >>> 47;
        l7 = l7 << 21 | l7 >>> 43;
        l5 ^= l6;
        l7 ^= l4;
        l6 = l6 << 32 | l6 >>> 32;
        l4 += l5;
        l6 += l7;
        l5 = l5 << 13 | l5 >>> 51;
        l7 = l7 << 16 | l7 >>> 48;
        l5 ^= l4;
        l7 ^= l6;
        l4 = l4 << 32 | l4 >>> 32;
        l6 += l5;
        l4 += l7;
        l5 = l5 << 17 | l5 >>> 47;
        l7 = l7 << 21 | l7 >>> 43;
        l5 ^= l6;
        l6 = l6 << 32 | l6 >>> 32;
        return l4 ^ l5 ^ l6 ^ (l7 ^= l4);
    }

    static {
        Object object = new int[]{1000, 10000, 100000, 1000000, 10000000, 100000000};
        Object object2 = new double[]{0.01, 0.02, 0.03, 0.04, 0.05, 0.1};
        int n = 272;
        for (int i = 0; i < ((int[])object).length; ++i) {
            GeoBloomFilter.DEFAULT_OFFSETS[i] = n;
            GeoBloomFilter.DEFAULT_LENGTHS[i] = (int)Math.ceil((double)(-object[i]) * Math.log(object2[i]) / (Math.log(2.0) * Math.log(2.0)));
            GeoBloomFilter.DEFAULT_LIMITS[i] = object[i];
            n += object[i];
        }
        try {
            Random random = new Random();
            hashkeys = new long[200];
            for (int i = 0; i < hashkeys.length; ++i) {
                GeoBloomFilter.hashkeys[i] = random.nextLong();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        object = null;
        try {
            object2 = Unsafe.class.getDeclaredField("theUnsafe");
            ((Field)object2).setAccessible(true);
            object = (Unsafe)((Field)object2).get(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        UNSAFE = object;
        base = UNSAFE.arrayBaseOffset(new byte[0].getClass());
    }
}

