/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.geo;

import com.geoxp.geo.HHCodeHelper;

public class GeoHashHelper {
    private static final String GEOHASH_CHAR_MAP = "0123456789bcdefghjkmnpqrstuvwxyz";

    public static final String fromHHCode(long l, int n) {
        long l2 = 0L;
        for (int i = 64; i > 0; i -= 2) {
            l2 >>= 2;
            l2 = 0L != (l & 1L) ? (l2 |= Long.MIN_VALUE) : (l2 &= Long.MAX_VALUE);
            l2 = 0L != ((l >>= 1) & 1L) ? (l2 |= 0x4000000000000000L) : (l2 &= 0xBFFFFFFFFFFFFFFFL);
            l >>= 1;
        }
        n = 2 * n;
        n -= n % 5;
        l2 >>= 64 - n;
        StringBuilder stringBuilder = new StringBuilder();
        while (n > 0) {
            stringBuilder.insert(0, GEOHASH_CHAR_MAP.charAt((int)(l2 & 0x1FL)));
            l2 >>= 5;
            n -= 5;
        }
        return stringBuilder.toString();
    }

    public static long toHHCode(String string) {
        int n;
        long l = 0L;
        for (n = 0; n < 12 && n < string.length(); ++n) {
            if (n > 0) {
                l <<= 5;
            }
            l |= (long)GEOHASH_CHAR_MAP.indexOf(string.charAt(n));
        }
        long[] lArray = HHCodeHelper.splitHHCode(l <<= 64 - 5 * n, 32);
        return HHCodeHelper.buildHHCode(lArray[1], lArray[0], 32);
    }
}

