/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.egress;

import com.netflix.curator.RetryPolicy;
import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.CuratorFrameworkFactory;
import com.netflix.curator.framework.state.ConnectionState;
import com.netflix.curator.retry.RetryNTimes;
import com.netflix.curator.x.discovery.ServiceCache;
import com.netflix.curator.x.discovery.ServiceDiscovery;
import com.netflix.curator.x.discovery.ServiceDiscoveryBuilder;
import com.netflix.curator.x.discovery.ServiceInstance;
import com.netflix.curator.x.discovery.details.ServiceCacheListener;
import io.warp10.continuum.DirectoryUtil;
import io.warp10.continuum.egress.StreamingMetadataIterator;
import io.warp10.continuum.store.DirectoryClient;
import io.warp10.continuum.store.MetadataIterator;
import io.warp10.continuum.store.thrift.data.DirectoryRequest;
import io.warp10.continuum.store.thrift.data.DirectoryStatsRequest;
import io.warp10.continuum.store.thrift.data.DirectoryStatsResponse;
import io.warp10.continuum.store.thrift.data.Metadata;
import io.warp10.continuum.store.thrift.service.DirectoryService;
import io.warp10.crypto.KeyStore;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.crypto.SipHashInline;
import io.warp10.script.HyperLogLogPlus;
import io.warp10.sensision.Sensision;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftDirectoryClient
implements ServiceCacheListener,
DirectoryClient {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftDirectoryClient.class);
    private static final String STATS_GTS_ESTIMATOR = "gts.estimate";
    private static final String STATS_CLASSES_ESTIMATOR = "classes.estimate";
    private static final String STATS_LABEL_NAMES_ESTIMATOR = "labelnames.estimate";
    private static final String STATS_LABEL_VALUES_ESTIMATOR = "labelvalues.estimate";
    private static final String STATS_PER_CLASS_ESTIMATOR = "per.class.estimate";
    private static final String STATS_PER_LABEL_VALUE_ESTIMATOR = "per.label.value.estimate";
    private static final String STATS_PARTIAL = "partial.results";
    private static final String STATS_ERROR = "error.rate";
    private final CuratorFramework curatorFramework;
    private final ServiceCache<Map> serviceCache;
    private Map<String, DirectoryService.Client> clientCache = new ConcurrentHashMap<String, DirectoryService.Client>();
    private Map<String, Integer> modulus = new ConcurrentHashMap<String, Integer>();
    private Map<String, Integer> remainder = new ConcurrentHashMap<String, Integer>();
    private Map<String, String> hosts = new ConcurrentHashMap<String, String>();
    private Map<String, Integer> streamingPorts = new ConcurrentHashMap<String, Integer>();
    private ExecutorService executor = null;
    private final Object executorMutex = new Object();
    private final Object clientCacheMutex = new Object();
    private final long[] SIPHASH_PSK;
    final AtomicBoolean transportException = new AtomicBoolean(false);
    private final boolean noProxy;

    public ThriftDirectoryClient(KeyStore keystore, Properties props) throws Exception {
        this.SIPHASH_PSK = SipHashInline.getKey(keystore.getKey("warp.siphash.directory.psk"));
        this.curatorFramework = CuratorFrameworkFactory.builder().connectionTimeoutMs(1000).retryPolicy((RetryPolicy)new RetryNTimes(10, 500)).connectString(props.getProperty("directory.zk.quorum")).build();
        this.curatorFramework.start();
        this.noProxy = "true".equals(props.getProperty("directory.streaming.noproxy"));
        ServiceDiscovery discovery = ServiceDiscoveryBuilder.builder(Map.class).basePath(props.getProperty("directory.zk.znode")).client(this.curatorFramework).build();
        discovery.start();
        this.serviceCache = discovery.serviceCacheBuilder().name("com.cityzendata.continuum.directory").build();
        this.serviceCache.addListener((Object)this);
        this.serviceCache.start();
        this.cacheChanged();
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheChanged() {
        Sensision.update((String)"warp.directory.client.cache.changed", (Map)Sensision.EMPTY_LABELS, (Number)1);
        Object object = this.clientCacheMutex;
        synchronized (object) {
            this.transportException.set(false);
            List instances = this.serviceCache.getInstances();
            ConcurrentHashMap<String, DirectoryService.Client> newClients = new ConcurrentHashMap<String, DirectoryService.Client>();
            ConcurrentHashMap<String, Integer> newModulus = new ConcurrentHashMap<String, Integer>();
            ConcurrentHashMap<String, Integer> newRemainder = new ConcurrentHashMap<String, Integer>();
            ConcurrentHashMap<String, String> newHosts = new ConcurrentHashMap<String, String>();
            ConcurrentHashMap<String, Integer> newStreamingPorts = new ConcurrentHashMap<String, Integer>();
            HashMap remaindersPerModulus = new HashMap();
            for (ServiceInstance instance : instances) {
                int modulus = Integer.parseInt(((Map)instance.getPayload()).get("modulus").toString());
                int remainder = Integer.parseInt(((Map)instance.getPayload()).get("remainder").toString());
                if (modulus <= 0 || remainder >= modulus) continue;
                if (!remaindersPerModulus.containsKey(modulus)) {
                    remaindersPerModulus.put(modulus, new HashSet());
                }
                ((Set)remaindersPerModulus.get(modulus)).add(remainder);
            }
            HashSet validModuli = new HashSet();
            for (Map.Entry entry : remaindersPerModulus.entrySet()) {
                if (((Set)entry.getValue()).size() != ((Integer)entry.getKey()).intValue()) continue;
                validModuli.add(entry.getKey());
            }
            for (ServiceInstance instance : instances) {
                int modulus = Integer.parseInt(((Map)instance.getPayload()).get("modulus").toString());
                if (!validModuli.contains(modulus)) continue;
                String id = instance.getId();
                String host = instance.getAddress();
                int port = instance.getPort();
                TSocket transport = new TSocket(host, port);
                try {
                    transport.open();
                }
                catch (TTransportException tte) {
                    continue;
                }
                transport = ((Map)instance.getPayload()).containsKey("thrift.maxframelen") ? new TFramedTransport((TTransport)transport, Integer.parseInt(((Map)instance.getPayload()).get("thrift.maxframelen").toString())) : new TFramedTransport((TTransport)transport);
                if (((Map)instance.getPayload()).containsKey("streaming.port")) {
                    newHosts.put(id, instance.getAddress());
                    newStreamingPorts.put(id, Integer.parseInt(((Map)instance.getPayload()).get("streaming.port").toString()));
                }
                DirectoryService.Client client = new DirectoryService.Client((TProtocol)new TCompactProtocol((TTransport)transport));
                newClients.put(id, client);
                newModulus.put(id, modulus);
                newRemainder.put(id, Integer.parseInt(((Map)instance.getPayload()).get("remainder").toString()));
            }
            Object object2 = this.clientCacheMutex;
            synchronized (object2) {
                for (Map.Entry<String, DirectoryService.Client> entry : this.clientCache.entrySet()) {
                    DirectoryService.Client client = entry.getValue();
                    synchronized (client) {
                        try {
                            entry.getValue().getInputProtocol().getTransport().close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                this.clientCache = newClients;
                this.modulus = newModulus;
                this.remainder = newRemainder;
                this.hosts = newHosts;
                this.streamingPorts = newStreamingPorts;
                if (null != this.executor) {
                    ExecutorService oldexecutor = this.executor;
                    Object object3 = this.executorMutex;
                    synchronized (object3) {
                        this.executor = Executors.newCachedThreadPool();
                    }
                    oldexecutor.shutdown();
                } else {
                    Object object4 = this.executorMutex;
                    synchronized (object4) {
                        this.executor = Executors.newCachedThreadPool();
                    }
                }
            }
        }
    }

    @Override
    public List<Metadata> find(DirectoryRequest request) throws IOException {
        throw new IOException("USE ITERATOR");
    }

    @Override
    public Map<String, Object> stats(DirectoryRequest request) throws IOException {
        return this.statsHttp(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> statsHttp(DirectoryRequest req) throws IOException {
        List<String> classSelector = req.getClassSelectors();
        List<Map<String, String>> labelsSelectors = req.getLabelsSelectors();
        HashSet<Integer> called = new HashSet<Integer>();
        long selectedmodulus = -1L;
        ArrayList<URL> urls = new ArrayList<URL>();
        ArrayList<Map.Entry<String, DirectoryService.Client>> servers = new ArrayList<Map.Entry<String, DirectoryService.Client>>();
        Iterator iterator = this.clientCacheMutex;
        synchronized (iterator) {
            servers.addAll(this.clientCache.entrySet());
        }
        Collections.shuffle(servers);
        for (Map.Entry entry : servers) {
            if (!this.streamingPorts.containsKey(entry.getKey())) continue;
            if (-1L == selectedmodulus) {
                selectedmodulus = this.modulus.get(entry.getKey()).intValue();
            }
            if ((long)this.modulus.get(entry.getKey()).intValue() != selectedmodulus || called.contains(this.remainder.get(entry.getKey()))) continue;
            String host = this.hosts.get(entry.getKey());
            int port = this.streamingPorts.get(entry.getKey());
            URL url = new URL("http://" + host + ":" + port + "" + "/directory-stats");
            urls.add(url);
            called.add(this.remainder.get(entry.getKey()));
        }
        DirectoryStatsRequest request = new DirectoryStatsRequest();
        request.setTimestamp(System.currentTimeMillis());
        request.setClassSelector(classSelector);
        request.setLabelsSelectors(labelsSelectors);
        long l = DirectoryUtil.computeHash((long)this.SIPHASH_PSK[0], (long)this.SIPHASH_PSK[1], (DirectoryStatsRequest)request);
        request.setHash(l);
        ArrayList<Future<DirectoryStatsResponse>> responses = new ArrayList<Future<DirectoryStatsResponse>>();
        AtomicBoolean transportException = new AtomicBoolean(false);
        TSerializer serializer = new TSerializer((TProtocolFactory)new TCompactProtocol.Factory());
        byte[] bytes = null;
        try {
            bytes = OrderPreservingBase64.encode(serializer.serialize((TBase)request));
        }
        catch (TException te) {
            throw new IOException(te);
        }
        final byte[] encodedReq = bytes;
        Object object = this.executorMutex;
        synchronized (object) {
            Iterator iterator2 = urls.iterator();
            while (iterator2.hasNext()) {
                URL uRL;
                final URL url = uRL = (URL)iterator2.next();
                responses.add(this.executor.submit(new Callable<DirectoryStatsResponse>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public DirectoryStatsResponse call() throws Exception {
                        HttpURLConnection conn = null;
                        try {
                            conn = (HttpURLConnection)(ThriftDirectoryClient.this.noProxy ? url.openConnection(Proxy.NO_PROXY) : url.openConnection());
                            conn.setDoOutput(true);
                            conn.setDoInput(true);
                            conn.setRequestMethod("POST");
                            conn.setChunkedStreamingMode(2048);
                            conn.connect();
                            OutputStream out = conn.getOutputStream();
                            out.write(encodedReq);
                            out.write(13);
                            out.write(10);
                            out.close();
                            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                            DirectoryStatsResponse resp = new DirectoryStatsResponse();
                            try {
                                String line;
                                while (null != (line = reader.readLine())) {
                                    byte[] data = OrderPreservingBase64.decode(line.getBytes(StandardCharsets.US_ASCII));
                                    TDeserializer deser = new TDeserializer((TProtocolFactory)new TCompactProtocol.Factory());
                                    deser.deserialize((TBase)resp, data);
                                }
                                reader.close();
                                reader = null;
                            }
                            catch (IOException ioe) {
                                if (null != reader) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                throw ioe;
                            }
                            DirectoryStatsResponse directoryStatsResponse = resp;
                            return directoryStatsResponse;
                        }
                        finally {
                            if (null != conn) {
                                try {
                                    conn.disconnect();
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                }));
            }
        }
        int count = 0;
        while (count != responses.size()) {
            LockSupport.parkNanos(1000L);
            count = 0;
            for (Future future : responses) {
                if (!future.isDone()) continue;
                ++count;
            }
        }
        return ThriftDirectoryClient.mergeStatsResponses(responses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> statsThrift(List<String> classSelector, List<Map<String, String>> labelsSelectors) throws IOException {
        final DirectoryStatsRequest request = new DirectoryStatsRequest();
        request.setTimestamp(System.currentTimeMillis());
        request.setClassSelector(classSelector);
        request.setLabelsSelectors(labelsSelectors);
        long hash = DirectoryUtil.computeHash((long)this.SIPHASH_PSK[0], (long)this.SIPHASH_PSK[1], (DirectoryStatsRequest)request);
        request.setHash(hash);
        ArrayList<Future<DirectoryStatsResponse>> responses = new ArrayList<Future<DirectoryStatsResponse>>();
        HashSet<Integer> called = new HashSet<Integer>();
        long selectedmodulus = -1L;
        ArrayList<Map.Entry<String, DirectoryService.Client>> servers = new ArrayList<Map.Entry<String, DirectoryService.Client>>();
        Object object = this.clientCacheMutex;
        synchronized (object) {
            servers.addAll(this.clientCache.entrySet());
            Collections.shuffle(servers);
            final AtomicBoolean transportException = new AtomicBoolean(false);
            Object object2 = this.executorMutex;
            synchronized (object2) {
                for (Map.Entry entry : servers) {
                    if (-1L == selectedmodulus) {
                        selectedmodulus = this.modulus.get(entry.getKey()).intValue();
                    }
                    if ((long)this.modulus.get(entry.getKey()).intValue() != selectedmodulus || called.contains(this.remainder.get(entry.getKey()))) continue;
                    final DirectoryService.Client clnt = (DirectoryService.Client)entry.getValue();
                    responses.add(this.executor.submit(new Callable<DirectoryStatsResponse>(){

                        @Override
                        public DirectoryStatsResponse call() throws Exception {
                            DirectoryService.Client client = clnt;
                            synchronized (client) {
                                try {
                                    DirectoryStatsResponse response = clnt.stats(request);
                                    return response;
                                }
                                catch (TTransportException tte) {
                                    LOG.error("call", (Throwable)tte);
                                    transportException.set(true);
                                    throw tte;
                                }
                            }
                        }
                    }));
                    called.add(this.remainder.get(entry.getKey()));
                }
            }
        }
        int count = 0;
        while (count != responses.size()) {
            LockSupport.parkNanos(1000L);
            count = 0;
            for (Future future : responses) {
                if (!future.isDone()) continue;
                ++count;
            }
        }
        if (this.transportException.get()) {
            this.cacheChanged();
        }
        return ThriftDirectoryClient.mergeStatsResponses(responses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> mergeStatsResponses(Iterable<Future<DirectoryStatsResponse>> responses) throws IOException {
        HashMap cardinalities;
        Throwable error = null;
        boolean partial = false;
        HyperLogLogPlus gtsCardinalityEstimator = null;
        HyperLogLogPlus classCardinalityEstimator = null;
        HyperLogLogPlus labelNamesCardinalityEstimator = null;
        HyperLogLogPlus labelValuesCardinalityEstimator = null;
        HashMap<String, HyperLogLogPlus> perClassCardinality = new HashMap<String, HyperLogLogPlus>();
        HashMap<String, HyperLogLogPlus> perLabelValueCardinality = new HashMap<String, HyperLogLogPlus>();
        for (Future<DirectoryStatsResponse> response : responses) {
            try {
                HyperLogLogPlus estimator;
                byte[] data;
                DirectoryStatsResponse resp = response.get();
                if (resp.isSetError()) {
                    partial = true;
                    continue;
                }
                HyperLogLogPlus card = HyperLogLogPlus.fromBytes(resp.getGtsCount());
                if (null == gtsCardinalityEstimator) {
                    gtsCardinalityEstimator = card;
                } else {
                    gtsCardinalityEstimator.fuse(card);
                }
                HyperLogLogPlus classCardinality = HyperLogLogPlus.fromBytes(resp.getClassCardinality());
                if (null == classCardinalityEstimator) {
                    classCardinalityEstimator = classCardinality;
                } else {
                    classCardinalityEstimator.fuse(classCardinality);
                }
                HyperLogLogPlus labelNamesCardinality = HyperLogLogPlus.fromBytes(resp.getLabelNamesCardinality());
                if (null == labelNamesCardinalityEstimator) {
                    labelNamesCardinalityEstimator = labelNamesCardinality;
                } else {
                    labelNamesCardinalityEstimator.fuse(labelNamesCardinality);
                }
                HyperLogLogPlus labelValuesCardinality = HyperLogLogPlus.fromBytes(resp.getLabelValuesCardinality());
                if (null == labelValuesCardinalityEstimator) {
                    labelValuesCardinalityEstimator = labelValuesCardinality;
                } else {
                    labelValuesCardinalityEstimator.fuse(labelValuesCardinality);
                }
                if (resp.getPerClassCardinalitySize() > 0) {
                    for (Map.Entry<String, ByteBuffer> entry : resp.getPerClassCardinality().entrySet()) {
                        data = new byte[entry.getValue().remaining()];
                        entry.getValue().get(data);
                        estimator = HyperLogLogPlus.fromBytes(data);
                        if (perClassCardinality.containsKey(entry.getKey())) {
                            ((HyperLogLogPlus)perClassCardinality.get(entry.getKey())).fuse(estimator);
                            continue;
                        }
                        perClassCardinality.put(entry.getKey(), estimator);
                    }
                }
                if (resp.getPerLabelValueCardinalitySize() <= 0) continue;
                for (Map.Entry<String, ByteBuffer> entry : resp.getPerLabelValueCardinality().entrySet()) {
                    data = new byte[entry.getValue().remaining()];
                    entry.getValue().get(data);
                    estimator = HyperLogLogPlus.fromBytes(data);
                    if (perLabelValueCardinality.containsKey(entry.getKey())) {
                        ((HyperLogLogPlus)perLabelValueCardinality.get(entry.getKey())).fuse(estimator);
                        continue;
                    }
                    perLabelValueCardinality.put(entry.getKey(), estimator);
                }
            }
            catch (ClassNotFoundException cnfe) {
                error = cnfe;
            }
            catch (CancellationException ce) {
                error = ce;
            }
            catch (ExecutionException ee) {
                error = ee.getCause();
            }
            catch (InterruptedException ie) {
                error = ie;
            }
            finally {
                if (null == error) continue;
                partial = true;
            }
        }
        HashMap<String, Object> stats = new HashMap<String, Object>();
        if (null != gtsCardinalityEstimator) {
            stats.put(STATS_GTS_ESTIMATOR, gtsCardinalityEstimator.cardinality());
        }
        if (null != classCardinalityEstimator) {
            stats.put(STATS_CLASSES_ESTIMATOR, classCardinalityEstimator.cardinality());
        }
        if (null != labelNamesCardinalityEstimator) {
            stats.put(STATS_LABEL_NAMES_ESTIMATOR, labelNamesCardinalityEstimator.cardinality());
        }
        if (null != labelValuesCardinalityEstimator) {
            stats.put(STATS_LABEL_VALUES_ESTIMATOR, labelValuesCardinalityEstimator.cardinality());
        }
        if (null != perClassCardinality) {
            cardinalities = new HashMap();
            for (Map.Entry entry : perClassCardinality.entrySet()) {
                cardinalities.put(entry.getKey(), ((HyperLogLogPlus)entry.getValue()).cardinality());
            }
            stats.put(STATS_PER_CLASS_ESTIMATOR, cardinalities);
        }
        if (null != perLabelValueCardinality) {
            cardinalities = new HashMap();
            for (Map.Entry entry : perLabelValueCardinality.entrySet()) {
                cardinalities.put(entry.getKey(), ((HyperLogLogPlus)entry.getValue()).cardinality());
            }
            stats.put(STATS_PER_LABEL_VALUE_ESTIMATOR, cardinalities);
        }
        if (partial) {
            stats.put(STATS_PARTIAL, true);
        }
        stats.put(STATS_ERROR, 1.04 / Math.sqrt(16384.0));
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetadataIterator iterator(DirectoryRequest request) throws IOException {
        List<String> classSelectors = request.getClassSelectors();
        List<Map<String, String>> labelsSelectors = request.getLabelsSelectors();
        HashSet<Integer> called = new HashSet<Integer>();
        long selectedmodulus = -1L;
        ArrayList<URL> urls = new ArrayList<URL>();
        ArrayList<Map.Entry<String, DirectoryService.Client>> servers = new ArrayList<Map.Entry<String, DirectoryService.Client>>();
        Iterator iterator = this.clientCacheMutex;
        synchronized (iterator) {
            servers.addAll(this.clientCache.entrySet());
        }
        Collections.shuffle(servers);
        for (Map.Entry entry : servers) {
            if (!this.streamingPorts.containsKey(entry.getKey())) continue;
            if (-1L == selectedmodulus) {
                selectedmodulus = this.modulus.get(entry.getKey()).intValue();
            }
            if ((long)this.modulus.get(entry.getKey()).intValue() != selectedmodulus || called.contains(this.remainder.get(entry.getKey()))) continue;
            String host = this.hosts.get(entry.getKey());
            int port = this.streamingPorts.get(entry.getKey());
            URL url = new URL("http://" + host + ":" + port + "" + "/directory-streaming");
            urls.add(url);
            called.add(this.remainder.get(entry.getKey()));
        }
        return new StreamingMetadataIterator(this.SIPHASH_PSK, request, urls, this.noProxy);
    }
}

