/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import io.warp10.continuum.gts.CustomBuffer;
import io.warp10.continuum.gts.GTSDecoder;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.gts.Varint;
import io.warp10.continuum.store.thrift.data.Metadata;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESWrapEngine;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.params.KeyParameter;

public class CustomBufferBasedGTSDecoder
extends GTSDecoder {
    private CustomBuffer buffer;
    private GeoTimeSerie.TYPE lastType = null;
    final long baseTimestamp;
    private long lastTimestamp = 0L;
    private long lastGeoXPPoint = 91480763316633925L;
    private long lastElevation = Long.MIN_VALUE;
    private long lastLongValue = Long.MAX_VALUE;
    private boolean lastBooleanValue = false;
    private double lastDoubleValue = Double.NaN;
    private BigDecimal lastBDValue = null;
    private String lastStringValue = null;
    private long previousLastTimestamp = this.lastTimestamp;
    private long previousLastGeoXPPoint = this.lastGeoXPPoint;
    private long previousLastElevation = this.lastElevation;
    private long previousLastLongValue = this.lastLongValue;
    private double previousLastDoubleValue = this.lastDoubleValue;
    private BigDecimal previousLastBDValue = this.lastBDValue;
    private String previousLastStringValue = this.lastStringValue;
    private boolean nextCalled = false;
    private final byte[] wrappingKey;
    private Metadata metadata;
    private int position;
    private long count = 0L;

    public CustomBufferBasedGTSDecoder(long baseTimestamp, CustomBuffer bb) {
        super(baseTimestamp, null);
        this.baseTimestamp = baseTimestamp;
        this.buffer = bb;
        this.wrappingKey = null;
    }

    public CustomBufferBasedGTSDecoder(long baseTimestamp, byte[] key, CustomBuffer bb) {
        super(baseTimestamp, null);
        this.baseTimestamp = baseTimestamp;
        this.buffer = bb;
        this.wrappingKey = (byte[])(null != key ? Arrays.copyOfRange(key, 0, key.length) : null);
        this.position = bb.position();
    }

    @Override
    public boolean next() {
        this.position = this.buffer.position();
        if (!this.buffer.hasRemaining()) {
            return false;
        }
        this.nextCalled = true;
        byte tsTypeFlag = this.buffer.get();
        if (0 == (tsTypeFlag & 0xFFFFFFFF)) {
            int enclen = (int)Varint.decodeUnsignedLong(this.buffer);
            if (null == this.wrappingKey) {
                this.buffer.position(this.buffer.position() + enclen);
                return this.next();
            }
            byte[] encrypted = new byte[enclen];
            this.buffer.get(encrypted);
            AESWrapEngine engine = new AESWrapEngine();
            KeyParameter params = new KeyParameter(this.wrappingKey);
            engine.init(false, (CipherParameters)params);
            try {
                byte[] decrypted = engine.unwrap(encrypted, 0, encrypted.length);
                PKCS7Padding padding = new PKCS7Padding();
                int padcount = padding.padCount(decrypted);
                this.buffer.insert(decrypted, 0, decrypted.length - padcount);
            }
            catch (InvalidCipherTextException decrypted) {
                // empty catch block
            }
            return this.next();
        }
        byte locElevFlag = 0;
        if (-128 == (tsTypeFlag & 0xFFFFFF80)) {
            if (!this.buffer.hasRemaining()) {
                return false;
            }
            locElevFlag = this.buffer.get();
        }
        switch (tsTypeFlag & 0x60) {
            case 96: {
                ByteOrder order = this.buffer.order();
                this.buffer.order(ByteOrder.BIG_ENDIAN);
                this.previousLastTimestamp = this.lastTimestamp;
                this.lastTimestamp = this.buffer.getLong();
                this.buffer.order(order);
                break;
            }
            case 32: {
                this.previousLastTimestamp = this.lastTimestamp;
                this.lastTimestamp = this.baseTimestamp;
                break;
            }
            case 64: {
                long delta = Varint.decodeSignedLong(this.buffer);
                this.previousLastTimestamp = this.lastTimestamp;
                this.lastTimestamp = this.baseTimestamp + delta;
                break;
            }
            case 0: {
                long delta = Varint.decodeSignedLong(this.buffer);
                this.previousLastTimestamp = this.lastTimestamp;
                this.lastTimestamp += delta;
                break;
            }
            default: {
                throw new RuntimeException("Invalid timestamp format.");
            }
        }
        if (64 == (locElevFlag & 0x40)) {
            if (16 != (locElevFlag & 0x10)) {
                if (32 == (locElevFlag & 0x20)) {
                    long delta = Varint.decodeSignedLong(this.buffer);
                    this.previousLastGeoXPPoint = this.lastGeoXPPoint;
                    this.lastGeoXPPoint += delta;
                } else {
                    ByteOrder order = this.buffer.order();
                    this.buffer.order(ByteOrder.BIG_ENDIAN);
                    this.previousLastGeoXPPoint = this.lastGeoXPPoint;
                    this.lastGeoXPPoint = this.buffer.getLong();
                    this.buffer.order(order);
                }
            }
        } else {
            this.previousLastGeoXPPoint = this.lastGeoXPPoint;
            this.lastGeoXPPoint = 91480763316633925L;
        }
        if (8 == (locElevFlag & 8)) {
            if (1 != (locElevFlag & 1)) {
                long encoded;
                boolean zigzag;
                boolean bl = zigzag = 4 == (locElevFlag & 4);
                if (zigzag) {
                    encoded = Varint.decodeSignedLong(this.buffer);
                } else {
                    ByteOrder order = this.buffer.order();
                    this.buffer.order(ByteOrder.BIG_ENDIAN);
                    encoded = this.buffer.getLong();
                    this.buffer.order(order);
                }
                if (2 == (locElevFlag & 2)) {
                    this.previousLastElevation = this.lastElevation;
                    this.lastElevation += encoded;
                } else {
                    this.previousLastElevation = this.lastElevation;
                    this.lastElevation = encoded;
                }
            }
        } else {
            this.previousLastElevation = this.lastElevation;
            this.lastElevation = Long.MIN_VALUE;
        }
        switch (tsTypeFlag & 0x18) {
            case 8: {
                long encoded;
                this.lastType = GeoTimeSerie.TYPE.LONG;
                if (1 == (tsTypeFlag & 1)) break;
                if (4 == (tsTypeFlag & 4)) {
                    encoded = Varint.decodeSignedLong(this.buffer);
                } else {
                    ByteOrder order = this.buffer.order();
                    this.buffer.order(ByteOrder.BIG_ENDIAN);
                    encoded = this.buffer.getLong();
                    this.buffer.order(order);
                }
                if (2 == (tsTypeFlag & 2)) {
                    this.previousLastLongValue = this.lastLongValue;
                    this.lastLongValue += encoded;
                    break;
                }
                this.previousLastLongValue = this.lastLongValue;
                this.lastLongValue = encoded;
                break;
            }
            case 16: {
                this.lastType = GeoTimeSerie.TYPE.DOUBLE;
                if (1 == (tsTypeFlag & 1)) break;
                if (4 == (tsTypeFlag & 4)) {
                    ByteOrder order = this.buffer.order();
                    this.buffer.order(ByteOrder.BIG_ENDIAN);
                    this.previousLastDoubleValue = this.lastDoubleValue;
                    this.lastDoubleValue = this.buffer.getDouble();
                    this.previousLastBDValue = this.lastBDValue;
                    this.lastBDValue = null;
                    this.buffer.order(order);
                    break;
                }
                byte scale = this.buffer.get();
                long unscaled = Varint.decodeSignedLong(this.buffer);
                this.previousLastBDValue = this.lastBDValue;
                this.lastBDValue = new BigDecimal(new BigInteger(Long.toString(unscaled)), scale);
                break;
            }
            case 24: {
                this.lastType = GeoTimeSerie.TYPE.STRING;
                if (1 == (tsTypeFlag & 1)) break;
                long len = Varint.decodeUnsignedLong(this.buffer);
                if (len > this.buffer.remaining()) {
                    throw new RuntimeException("Invalid string length.");
                }
                byte[] utf8 = new byte[(int)len];
                this.buffer.get(utf8);
                this.previousLastStringValue = this.lastStringValue;
                this.lastStringValue = new String(utf8, StandardCharsets.UTF_8);
                break;
            }
            case 0: {
                if (7 == (tsTypeFlag & 7)) {
                    this.lastType = GeoTimeSerie.TYPE.UNDEFINED;
                    break;
                }
                this.lastType = GeoTimeSerie.TYPE.BOOLEAN;
                if (4 == (tsTypeFlag & 7)) {
                    this.lastBooleanValue = true;
                    break;
                }
                if (2 == (tsTypeFlag & 7)) {
                    this.lastBooleanValue = false;
                    break;
                }
                throw new RuntimeException("Invalid boolean value.");
            }
            default: {
                throw new RuntimeException("Invalid type encountered!");
            }
        }
        return true;
    }

    @Override
    public long getTimestamp() {
        return this.lastTimestamp;
    }

    @Override
    public long getLocation() {
        return this.lastGeoXPPoint;
    }

    @Override
    public long getElevation() {
        return this.lastElevation;
    }

    @Override
    public Object getValue() {
        switch (this.lastType) {
            case BOOLEAN: {
                return this.lastBooleanValue;
            }
            case LONG: {
                return this.lastLongValue;
            }
            case DOUBLE: {
                return null == this.lastBDValue ? Double.valueOf(this.lastDoubleValue) : this.lastBDValue;
            }
            case STRING: {
                return this.lastStringValue;
            }
        }
        return null;
    }

    @Override
    public GeoTimeSerie decode() {
        throw new RuntimeException("Not Implemented.");
    }

    @Override
    public GTSEncoder getEncoder(boolean safeMetadata) throws IOException {
        throw new RuntimeException("Not Implemented.");
    }

    @Override
    public int getRemainingSize() {
        return (int)this.buffer.remaining();
    }

    @Override
    void initialize(long initialTimestamp, long initialGeoXPPoint, long initialElevation, long initialLongValue, double initialDoubleValue, BigDecimal initialBDValue, String initialStringValue) {
        this.lastTimestamp = initialTimestamp;
        this.lastGeoXPPoint = initialGeoXPPoint;
        this.lastElevation = initialElevation;
        this.lastLongValue = initialLongValue;
        this.lastDoubleValue = initialDoubleValue;
        this.lastBDValue = initialBDValue;
        this.lastStringValue = initialStringValue;
    }

    @Override
    public GTSDecoder dedup() throws IOException {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public ByteBuffer getBuffer() {
        throw new RuntimeException("Not Implemented");
    }
}

