/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import io.warp10.continuum.gts.GTSDecoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.gts.Varint;
import io.warp10.continuum.store.thrift.data.Metadata;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPOutputStream;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESWrapEngine;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.params.KeyParameter;
import sun.misc.FloatingDecimal;

public class GTSEncoder
implements Cloneable {
    static final byte FLAGS_MASK_ENCRYPTED = -1;
    static final byte FLAGS_MASK_CONTINUATION = -128;
    static final byte FLAGS_MASK_TIMESTAMP = 96;
    static final byte FLAGS_MASK_TYPE = 24;
    static final byte FLAGS_MASK_TYPE_FLAGS = 7;
    static final byte FLAGS_MASK_LOCATION = 112;
    static final byte FLAGS_MASK_ELEVATION = 15;
    public static final byte FLAGS_ENCRYPTED = 0;
    static final byte FLAGS_CONTINUATION = -128;
    static final byte FLAGS_TIMESTAMP_ZIGZAG_DELTA_PREVIOUS = 0;
    static final byte FLAGS_TIMESTAMP_EQUALS_BASE = 32;
    static final byte FLAGS_TIMESTAMP_ZIGZAG_DELTA_BASE = 64;
    static final byte FLAGS_TIMESTAMP_RAW_ABSOLUTE = 96;
    static final byte FLAGS_TYPE_BOOLEAN = 0;
    static final byte FLAGS_TYPE_LONG = 8;
    static final byte FLAGS_TYPE_DOUBLE = 16;
    static final byte FLAGS_TYPE_STRING = 24;
    static final byte FLAGS_STRING_BINARY = 2;
    static final byte FLAGS_BOOLEAN_VALUE_TRUE = 4;
    static final byte FLAGS_BOOLEAN_VALUE_FALSE = 2;
    static final byte FLAGS_DELETE_MARKER = 7;
    static final byte FLAGS_LONG_ZIGZAG = 4;
    static final byte FLAGS_LONG_DELTA_PREVIOUS = 2;
    static final byte FLAGS_DOUBLE_IEEE754 = 4;
    static final byte FLAGS_VALUE_IDENTICAL = 1;
    static final byte FLAGS_LOCATION = 64;
    static final byte FLAGS_LOCATION_GEOXPPOINT_ZIGZAG_DELTA = 32;
    static final byte FLAGS_LOCATION_IDENTICAL = 16;
    static final byte FLAGS_ELEVATION = 8;
    static final byte FLAGS_ELEVATION_ZIGZAG = 4;
    static final byte FLAGS_ELEVATION_DELTA_PREVIOUS = 2;
    static final byte FLAGS_ELEVATION_IDENTICAL = 1;
    private boolean readonly = false;
    private long baseTimestamp = 0L;
    private long lastTimestamp = 0L;
    private long lastGeoXPPoint = 91480763316633925L;
    private long lastElevation = Long.MIN_VALUE;
    private long lastLongValue = Long.MAX_VALUE;
    private BigDecimal lastBDValue = null;
    private double lastDoubleValue = Double.NaN;
    private String lastStringValue = null;
    private String binaryString = null;
    private long initialTimestamp = this.lastTimestamp;
    private long initialGeoXPPoint = this.lastGeoXPPoint;
    private long initialElevation = this.lastElevation;
    private long initialLongValue = this.lastLongValue;
    private double initialDoubleValue = this.lastDoubleValue;
    private BigDecimal initialBDValue = this.lastBDValue;
    private String initialStringValue = this.lastStringValue;
    ByteArrayOutputStream stream;
    private byte[] wrappingKey;
    private Metadata metadata;
    private long count = 0L;
    private boolean noDeltaMetaTimestamp = false;
    private boolean noDeltaMetaLocation = false;
    private boolean noDeltaMetaElevation = false;
    private boolean noDeltaValue = false;
    private byte[] buf8 = new byte[10];
    private byte[] buf10 = this.buf8;

    public GTSEncoder() {
        this.stream = new ByteArrayOutputStream();
        this.wrappingKey = null;
    }

    public GTSEncoder(long baseTimestamp, byte[] key, byte[] content) {
        this.baseTimestamp = baseTimestamp;
        this.wrappingKey = null == key ? null : Arrays.copyOf(key, key.length);
        this.stream = new ByteArrayOutputStream();
        try {
            this.stream.write(content);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.safeDelta();
    }

    public GTSEncoder(long baseTimestamp) {
        this.baseTimestamp = baseTimestamp;
        this.stream = new ByteArrayOutputStream();
        this.wrappingKey = null;
    }

    public GTSEncoder(long baseTimestamp, byte[] key) {
        this.baseTimestamp = baseTimestamp;
        this.stream = new ByteArrayOutputStream();
        this.wrappingKey = null == key ? null : Arrays.copyOf(key, key.length);
    }

    public GTSEncoder(long baseTimestamp, byte[] key, int size) {
        this.baseTimestamp = baseTimestamp;
        this.stream = new ByteArrayOutputStream(size);
        this.wrappingKey = null == key ? null : Arrays.copyOf(key, key.length);
    }

    public synchronized int addValue(long timestamp, long location, long elevation, Object value) throws IOException {
        if (this.readonly) {
            throw new IOException("Encoder is read-only.");
        }
        int tsTypeFlag = 0;
        if (this.noDeltaMetaTimestamp) {
            tsTypeFlag = (byte)(tsTypeFlag | 0x60);
            this.noDeltaMetaTimestamp = false;
        } else {
            long deltaLast;
            long deltaBase;
            tsTypeFlag = this.baseTimestamp == timestamp ? (int)((byte)(tsTypeFlag | 0x20)) : (0L != this.lastTimestamp ? ((deltaBase = Math.abs(timestamp - this.baseTimestamp)) < (deltaLast = Math.abs(timestamp - this.lastTimestamp)) ? (deltaBase < 0x1000000000000L ? (int)((byte)(tsTypeFlag | 0x40)) : (int)((byte)(tsTypeFlag | 0x60))) : (deltaLast < 0x1000000000000L ? (int)((byte)(tsTypeFlag | 0)) : (int)((byte)(tsTypeFlag | 0x60)))) : ((deltaBase = Math.abs(timestamp - this.baseTimestamp)) < 0x1000000000000L ? (int)((byte)(tsTypeFlag | 0x40)) : (int)((byte)(tsTypeFlag | 0x60))));
        }
        if (value instanceof BigInteger || value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
            tsTypeFlag = (byte)(tsTypeFlag | 8);
            long longValue = ((Number)value).longValue();
            if (!this.noDeltaValue && Long.MAX_VALUE != this.lastLongValue && longValue == this.lastLongValue) {
                tsTypeFlag = (byte)(tsTypeFlag | 1);
            } else {
                long offset = longValue - this.lastLongValue;
                if (!this.noDeltaValue && Long.MAX_VALUE != this.lastLongValue && Math.abs(offset) < Math.abs(longValue) && Math.abs(offset) < 0x1000000000000L) {
                    tsTypeFlag = (byte)(tsTypeFlag | 2);
                    tsTypeFlag = (byte)(tsTypeFlag | 4);
                } else if (Math.abs(longValue) < 0x1000000000000L) {
                    tsTypeFlag = (byte)(tsTypeFlag | 4);
                }
            }
        } else if (value instanceof Boolean) {
            tsTypeFlag = (byte)(tsTypeFlag | 0);
            tsTypeFlag = ((Boolean)value).booleanValue() ? (int)((byte)(tsTypeFlag | 4)) : (int)((byte)(tsTypeFlag | 2));
        } else if (value instanceof String) {
            tsTypeFlag = (byte)(tsTypeFlag | 0x18);
            if (((String)value).equals(this.lastStringValue)) {
                tsTypeFlag = (byte)(tsTypeFlag | 1);
            }
        } else if (value instanceof byte[]) {
            tsTypeFlag = (byte)(tsTypeFlag | 0x1A);
            this.binaryString = new String((byte[])value, StandardCharsets.ISO_8859_1);
            if (this.binaryString.equals(this.lastStringValue)) {
                tsTypeFlag = (byte)(tsTypeFlag | 1);
            }
        } else if (value instanceof Double || value instanceof Float) {
            tsTypeFlag = (byte)(tsTypeFlag | 0x10);
            tsTypeFlag = null == this.lastBDValue && this.lastDoubleValue == ((Number)value).doubleValue() ? (int)((byte)(tsTypeFlag | 1)) : (int)((byte)(tsTypeFlag | 4));
        } else if (value instanceof BigDecimal) {
            tsTypeFlag = (byte)(tsTypeFlag | 0x10);
            BigDecimal doubleValue = (BigDecimal)value;
            doubleValue = doubleValue.stripTrailingZeros();
            if (null != this.lastBDValue && 0 == this.lastBDValue.compareTo(doubleValue)) {
                tsTypeFlag = (byte)(tsTypeFlag | 1);
            } else {
                int scale = doubleValue.scale();
                if (scale > 127 || scale < -128) {
                    tsTypeFlag = (byte)(tsTypeFlag | 4);
                } else {
                    BigInteger bi = doubleValue.unscaledValue();
                    int bitlen = bi.bitLength();
                    if (bitlen > 46) {
                        tsTypeFlag = (byte)(tsTypeFlag | 4);
                    }
                }
            }
        } else if (null == value) {
            tsTypeFlag = (byte)(tsTypeFlag | 0);
            tsTypeFlag = (byte)(tsTypeFlag | 7);
        } else {
            throw new RuntimeException("Unsuported value type '" + value.getClass() + "'");
        }
        int locElevFlag = 0;
        if (91480763316633925L != location && null != value) {
            tsTypeFlag = (byte)(tsTypeFlag | 0xFFFFFF80);
            locElevFlag = (byte)(locElevFlag | 0x40);
            if (91480763316633925L != this.lastGeoXPPoint && !this.noDeltaMetaLocation) {
                if (this.lastGeoXPPoint == location) {
                    locElevFlag = (byte)(locElevFlag | 0x10);
                } else {
                    long delta = location - this.lastGeoXPPoint;
                    if (Math.abs(delta) < 0x1000000000000L) {
                        locElevFlag = (byte)(locElevFlag | 0x20);
                    }
                }
            } else {
                this.noDeltaMetaLocation = false;
            }
        } else {
            this.lastGeoXPPoint = 91480763316633925L;
        }
        if (Long.MIN_VALUE != elevation && null != value) {
            tsTypeFlag = (byte)(tsTypeFlag | 0xFFFFFF80);
            locElevFlag = (byte)(locElevFlag | 8);
            if (Long.MIN_VALUE != this.lastElevation && !this.noDeltaMetaElevation) {
                if (this.lastElevation == elevation) {
                    locElevFlag = (byte)(locElevFlag | 1);
                } else {
                    long delta = elevation - this.lastElevation;
                    if (Math.abs(delta) < 0x1000000000000L) {
                        locElevFlag = (byte)(locElevFlag | 2);
                        locElevFlag = (byte)(locElevFlag | 4);
                    } else if (Math.abs(elevation) < 0x1000000000000L) {
                        locElevFlag = (byte)(locElevFlag | 4);
                    }
                }
            } else {
                if (Math.abs(elevation) < 0x1000000000000L) {
                    locElevFlag = (byte)(locElevFlag | 4);
                }
                this.noDeltaMetaElevation = false;
            }
        } else {
            this.lastElevation = Long.MIN_VALUE;
        }
        this.stream.write(tsTypeFlag);
        if (-128 == (tsTypeFlag & 0xFFFFFF80)) {
            this.stream.write(locElevFlag);
        }
        switch (tsTypeFlag & 0x60) {
            case 96: {
                byte[] buf = this.buf8;
                buf[0] = (byte)(timestamp >> 56 & 0xFFL);
                buf[1] = (byte)(timestamp >> 48 & 0xFFL);
                buf[2] = (byte)(timestamp >> 40 & 0xFFL);
                buf[3] = (byte)(timestamp >> 32 & 0xFFL);
                buf[4] = (byte)(timestamp >> 24 & 0xFFL);
                buf[5] = (byte)(timestamp >> 16 & 0xFFL);
                buf[6] = (byte)(timestamp >> 8 & 0xFFL);
                buf[7] = (byte)(timestamp & 0xFFL);
                this.stream.write(buf, 0, 8);
                break;
            }
            case 32: {
                break;
            }
            case 64: {
                int l = Varint.encodeSignedLongInBuf(timestamp - this.baseTimestamp, this.buf10);
                this.stream.write(this.buf10, 0, l);
                break;
            }
            case 0: {
                int ll = Varint.encodeSignedLongInBuf(timestamp - this.lastTimestamp, this.buf10);
                this.stream.write(this.buf10, 0, ll);
                break;
            }
            default: {
                throw new RuntimeException("Invalid timestamp format.");
            }
        }
        this.lastTimestamp = timestamp;
        if (64 == (locElevFlag & 0x40)) {
            if (16 != (locElevFlag & 0x10)) {
                if (32 == (locElevFlag & 0x20)) {
                    long delta = location - this.lastGeoXPPoint;
                    int l = Varint.encodeSignedLongInBuf(delta, this.buf10);
                    this.stream.write(this.buf10, 0, l);
                } else {
                    byte[] buf = this.buf8;
                    buf[0] = (byte)(location >> 56 & 0xFFL);
                    buf[1] = (byte)(location >> 48 & 0xFFL);
                    buf[2] = (byte)(location >> 40 & 0xFFL);
                    buf[3] = (byte)(location >> 32 & 0xFFL);
                    buf[4] = (byte)(location >> 24 & 0xFFL);
                    buf[5] = (byte)(location >> 16 & 0xFFL);
                    buf[6] = (byte)(location >> 8 & 0xFFL);
                    buf[7] = (byte)(location & 0xFFL);
                    this.stream.write(buf, 0, 8);
                }
            }
            this.lastGeoXPPoint = location;
        }
        if (8 == (locElevFlag & 8)) {
            if (1 != (locElevFlag & 1)) {
                boolean zigzag = 4 == (locElevFlag & 4);
                long toencode = elevation;
                if (2 == (locElevFlag & 2)) {
                    toencode = elevation - this.lastElevation;
                }
                if (zigzag) {
                    int l = Varint.encodeSignedLongInBuf(toencode, this.buf10);
                    this.stream.write(this.buf10, 0, l);
                } else {
                    byte[] buf = this.buf8;
                    buf[0] = (byte)(toencode >> 56 & 0xFFL);
                    buf[1] = (byte)(toencode >> 48 & 0xFFL);
                    buf[2] = (byte)(toencode >> 40 & 0xFFL);
                    buf[3] = (byte)(toencode >> 32 & 0xFFL);
                    buf[4] = (byte)(toencode >> 24 & 0xFFL);
                    buf[5] = (byte)(toencode >> 16 & 0xFFL);
                    buf[6] = (byte)(toencode >> 8 & 0xFFL);
                    buf[7] = (byte)(toencode & 0xFFL);
                    this.stream.write(buf, 0, 8);
                }
            }
            this.lastElevation = elevation;
        }
        switch (tsTypeFlag & 0x18) {
            case 24: {
                if (1 == (tsTypeFlag & 1)) break;
                if (2 == (tsTypeFlag & 2)) {
                    byte[] bytes = (byte[])value;
                    int l = Varint.encodeUnsignedLongInBuf(bytes.length, this.buf10);
                    this.stream.write(this.buf10, 0, l);
                    this.stream.write(bytes);
                    this.lastStringValue = this.binaryString;
                    break;
                }
                byte[] utf8 = ((String)value).getBytes(StandardCharsets.UTF_8);
                int l = Varint.encodeUnsignedLongInBuf(utf8.length, this.buf10);
                this.stream.write(this.buf10, 0, l);
                this.stream.write(utf8);
                this.lastStringValue = (String)value;
                break;
            }
            case 8: {
                long lvalue;
                if (1 == (tsTypeFlag & 1)) break;
                long toencode = lvalue = ((Number)value).longValue();
                if (2 == (tsTypeFlag & 2)) {
                    toencode = lvalue - this.lastLongValue;
                }
                if (4 == (tsTypeFlag & 4)) {
                    int l = Varint.encodeSignedLongInBuf(toencode, this.buf10);
                    this.stream.write(this.buf10, 0, l);
                } else {
                    byte[] buf = this.buf8;
                    buf[0] = (byte)(toencode >> 56 & 0xFFL);
                    buf[1] = (byte)(toencode >> 48 & 0xFFL);
                    buf[2] = (byte)(toencode >> 40 & 0xFFL);
                    buf[3] = (byte)(toencode >> 32 & 0xFFL);
                    buf[4] = (byte)(toencode >> 24 & 0xFFL);
                    buf[5] = (byte)(toencode >> 16 & 0xFFL);
                    buf[6] = (byte)(toencode >> 8 & 0xFFL);
                    buf[7] = (byte)(toencode & 0xFFL);
                    this.stream.write(buf, 0, 8);
                }
                this.noDeltaValue = false;
                this.lastLongValue = lvalue;
                break;
            }
            case 16: {
                if (1 == (tsTypeFlag & 1)) break;
                if (4 == (tsTypeFlag & 4)) {
                    byte[] buf = this.buf8;
                    ByteBuffer bb = ByteBuffer.wrap(buf);
                    bb.order(ByteOrder.BIG_ENDIAN);
                    this.lastDoubleValue = ((Number)value).doubleValue();
                    bb.putDouble(this.lastDoubleValue);
                    this.stream.write(buf, 0, 8);
                    this.lastBDValue = null;
                    break;
                }
                BigDecimal dvalue = (BigDecimal)value;
                dvalue = dvalue.stripTrailingZeros();
                int scale = dvalue.scale();
                long unscaled = dvalue.unscaledValue().longValue();
                this.stream.write(scale);
                int l = Varint.encodeSignedLongInBuf(unscaled, this.buf10);
                this.stream.write(this.buf10, 0, l);
                this.lastBDValue = dvalue;
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new RuntimeException("Invalid type encountered!");
            }
        }
        ++this.count;
        return this.stream.size();
    }

    public void setWrappingKey(byte[] key) {
        if (this.readonly) {
            throw new RuntimeException("Encoder is read-only.");
        }
        this.wrappingKey = null == key ? null : Arrays.copyOf(key, key.length);
    }

    public byte[] getBytes() {
        if (null == this.wrappingKey) {
            return this.stream.toByteArray();
        }
        AESWrapEngine engine = new AESWrapEngine();
        KeyParameter params = new KeyParameter(this.wrappingKey);
        engine.init(true, (CipherParameters)params);
        PKCS7Padding padding = new PKCS7Padding();
        byte[] unpadded = this.stream.toByteArray();
        byte[] padded = new byte[unpadded.length + (8 - unpadded.length % 8)];
        System.arraycopy(unpadded, 0, padded, 0, unpadded.length);
        padding.addPadding(padded, unpadded.length);
        byte[] encrypted = engine.wrap(padded, 0, padded.length);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(0);
            baos.write(Varint.encodeUnsignedLong(encrypted.length));
            baos.write(encrypted);
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public int size() {
        return this.stream.size();
    }

    public long getCount() {
        return this.count;
    }

    public synchronized void encode(GeoTimeSerie gts) throws IOException {
        for (int i = 0; i < gts.values; ++i) {
            this.addValue(gts.ticks[i], null != gts.locations ? gts.locations[i] : 91480763316633925L, null != gts.elevations ? gts.elevations[i] : Long.MIN_VALUE, GTSHelper.valueAtIndex(gts, i));
        }
    }

    public synchronized void encodeOptimized(GeoTimeSerie gts) throws IOException {
        StringBuilder sb = new StringBuilder();
        char[] chars = null;
        for (int i = 0; i < gts.values; ++i) {
            Object value = GTSHelper.valueAtIndex(gts, i);
            if (value instanceof Double && Double.isFinite((Double)value)) {
                sb.setLength(0);
                FloatingDecimal.BinaryToASCIIConverter btoa = FloatingDecimal.getBinaryToASCIIConverter((double)((Double)value));
                btoa.appendTo((Appendable)sb);
                if (null == chars || chars.length < sb.length()) {
                    chars = new char[sb.length()];
                }
                sb.getChars(0, sb.length(), chars, 0);
                value = new BigDecimal(chars, 0, sb.length());
            }
            this.addValue(gts.ticks[i], null != gts.locations ? gts.locations[i] : 91480763316633925L, null != gts.elevations ? gts.elevations[i] : Long.MIN_VALUE, value);
        }
    }

    public static Object optimizeValue(Object value) {
        if (value instanceof Double && Double.isFinite((Double)value)) {
            StringBuilder sb = new StringBuilder();
            Object chars = null;
            FloatingDecimal.BinaryToASCIIConverter btoa = FloatingDecimal.getBinaryToASCIIConverter((double)((Double)value));
            btoa.appendTo((Appendable)sb);
            value = new BigDecimal(sb.toString());
        }
        return value;
    }

    public synchronized GTSDecoder getDecoder(boolean safeMetadata) {
        GTSDecoder decoder = new GTSDecoder(this.baseTimestamp, this.wrappingKey, ByteBuffer.wrap(this.stream.toByteArray()));
        if (!safeMetadata) {
            decoder.setMetadata(this.getMetadata());
        } else {
            decoder.safeSetMetadata(this.getMetadata());
        }
        decoder.initialize(this.initialTimestamp, this.initialGeoXPPoint, this.initialElevation, this.initialLongValue, this.initialDoubleValue, this.initialBDValue, this.initialStringValue);
        decoder.setCount(this.getCount());
        return decoder;
    }

    public GTSDecoder getDecoder() {
        return this.getDecoder(false);
    }

    public synchronized GTSDecoder getUnsafeDecoder(boolean blockWrites) {
        if (null != this.wrappingKey) {
            return this.getDecoder(true);
        }
        final AtomicReference aref = new AtomicReference();
        final AtomicInteger alen = new AtomicInteger();
        final AtomicInteger aoff = new AtomicInteger();
        OutputStream out = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                aref.set(b);
                alen.set(len);
                aoff.set(off);
            }
        };
        try {
            this.stream.writeTo(out);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        GTSDecoder decoder = new GTSDecoder(this.baseTimestamp, this.wrappingKey, ByteBuffer.wrap((byte[])aref.get(), aoff.get(), alen.get()));
        decoder.safeSetMetadata(this.getMetadata());
        decoder.initialize(this.initialTimestamp, this.initialGeoXPPoint, this.initialElevation, this.initialLongValue, this.initialDoubleValue, this.initialBDValue, this.initialStringValue);
        decoder.setCount(this.getCount());
        if (blockWrites) {
            this.readonly = true;
        }
        return decoder;
    }

    synchronized void initialize(long initialTimestamp, long initialGeoXPPoint, long initialElevation, long initialLongValue, double initialDoubleValue, BigDecimal initialBDValue, String initialStringValue) {
        if (this.readonly) {
            throw new RuntimeException("Encoder is read-only.");
        }
        this.initialTimestamp = initialTimestamp;
        this.initialGeoXPPoint = initialGeoXPPoint;
        this.initialElevation = initialElevation;
        this.initialLongValue = initialLongValue;
        this.initialDoubleValue = initialDoubleValue;
        this.initialBDValue = initialBDValue;
        this.initialStringValue = initialStringValue;
    }

    public synchronized void reset(GTSEncoder encoder) throws IOException {
        if (this.readonly) {
            throw new RuntimeException("Encoder is read-only.");
        }
        this.initialize(encoder.initialTimestamp, encoder.initialGeoXPPoint, encoder.initialElevation, encoder.initialLongValue, encoder.initialDoubleValue, encoder.initialBDValue, encoder.initialStringValue);
        this.baseTimestamp = encoder.baseTimestamp;
        this.count = encoder.count;
        this.lastBDValue = encoder.lastBDValue;
        this.lastDoubleValue = encoder.lastDoubleValue;
        this.lastGeoXPPoint = encoder.lastGeoXPPoint;
        this.lastElevation = encoder.lastElevation;
        this.lastLongValue = encoder.lastLongValue;
        this.lastStringValue = encoder.lastStringValue;
        this.lastTimestamp = encoder.lastTimestamp;
        this.metadata = encoder.metadata;
        this.wrappingKey = encoder.wrappingKey;
        this.noDeltaMetaTimestamp = encoder.noDeltaMetaTimestamp;
        this.noDeltaMetaLocation = encoder.noDeltaMetaLocation;
        this.noDeltaMetaElevation = encoder.noDeltaMetaElevation;
        this.noDeltaValue = encoder.noDeltaValue;
        this.stream.reset();
        encoder.stream.writeTo(this.stream);
    }

    public synchronized void reset(long baseTS) throws IOException {
        if (this.readonly) {
            throw new RuntimeException("Encoder is read-only.");
        }
        this.baseTimestamp = baseTS;
        this.lastTimestamp = 0L;
        this.lastGeoXPPoint = 91480763316633925L;
        this.lastElevation = Long.MIN_VALUE;
        this.lastLongValue = Long.MAX_VALUE;
        this.lastBDValue = null;
        this.lastDoubleValue = Double.NaN;
        this.lastStringValue = null;
        this.initialTimestamp = this.lastTimestamp;
        this.initialGeoXPPoint = this.lastGeoXPPoint;
        this.initialElevation = this.lastElevation;
        this.initialLongValue = this.lastLongValue;
        this.initialDoubleValue = this.lastDoubleValue;
        this.initialBDValue = this.lastBDValue;
        this.initialStringValue = this.lastStringValue;
        this.metadata = null;
        this.count = 0L;
        this.noDeltaMetaTimestamp = false;
        this.noDeltaMetaLocation = false;
        this.noDeltaMetaElevation = false;
        this.noDeltaValue = false;
        this.stream.reset();
    }

    public synchronized void resize(int target) throws IOException {
        if (this.readonly) {
            throw new RuntimeException("Encoder is read-only.");
        }
        int size = this.size();
        if (target > size) {
            ByteArrayOutputStream out = new ByteArrayOutputStream(target);
            this.stream.writeTo(out);
            this.stream = out;
        }
    }

    public synchronized void merge(GTSEncoder encoder) throws IOException {
        if (this.readonly) {
            throw new RuntimeException("Encoder is read-only.");
        }
        if (0 == this.size() && this.baseTimestamp == encoder.baseTimestamp && Arrays.equals(this.wrappingKey, encoder.wrappingKey)) {
            this.reset(encoder);
            return;
        }
        if (this.baseTimestamp != encoder.baseTimestamp || !Arrays.equals(this.wrappingKey, encoder.wrappingKey) || this.lastTimestamp != encoder.initialTimestamp || this.lastGeoXPPoint != encoder.initialGeoXPPoint || this.lastElevation != encoder.initialElevation || this.lastLongValue != encoder.initialLongValue || this.lastDoubleValue != encoder.initialDoubleValue || this.lastBDValue != encoder.initialBDValue || this.lastStringValue != encoder.initialStringValue) {
            GTSDecoder decoder = encoder.getDecoder(true);
            while (decoder.next()) {
                this.addValue(decoder.getTimestamp(), decoder.getLocation(), decoder.getElevation(), decoder.getBinaryValue());
            }
        } else {
            this.stream.write(encoder.getBytes());
            this.lastTimestamp = encoder.lastTimestamp;
            this.lastElevation = encoder.lastElevation;
            this.lastGeoXPPoint = encoder.lastGeoXPPoint;
            this.lastLongValue = encoder.lastLongValue;
            this.lastBDValue = encoder.lastBDValue;
            this.lastDoubleValue = encoder.lastDoubleValue;
            this.lastStringValue = encoder.lastStringValue;
            this.count += encoder.getCount();
        }
    }

    public long getBaseTimestamp() {
        return this.baseTimestamp;
    }

    public long getClassId() {
        return this.getMetadata().getClassId();
    }

    public void setClassId(long classId) {
        this.getMetadata().setClassId(classId);
    }

    public long getLabelsId() {
        return this.getMetadata().getLabelsId();
    }

    public void setLabelsId(long labelsId) {
        this.getMetadata().setLabelsId(labelsId);
    }

    public String getName() {
        return this.getMetadata().getName();
    }

    public void setName(String name) {
        this.getMetadata().setName(name);
    }

    public Map<String, String> getLabels() {
        return Collections.unmodifiableMap(this.getMetadata().getLabels());
    }

    public void setLabels(Map<String, String> labels) {
        this.getMetadata().setLabels(new HashMap<String, String>(labels));
    }

    public void setLabel(String key, String value) {
        this.getMetadata().getLabels().put(key, value);
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = new Metadata(metadata);
    }

    public void safeSetMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Metadata getMetadata() {
        if (null == this.metadata) {
            this.metadata = new Metadata();
        }
        if (null == this.metadata.getLabels()) {
            this.metadata.setLabels(new HashMap<String, String>());
        }
        if (null == this.metadata.getAttributes()) {
            this.metadata.setAttributes(new HashMap<String, String>());
        }
        return this.metadata;
    }

    public Metadata getRawMetadata() {
        return this.metadata;
    }

    public long getLastTimestamp() {
        return this.lastTimestamp;
    }

    public void safeDelta() {
        this.noDeltaMetaTimestamp = true;
        this.noDeltaMetaLocation = true;
        this.noDeltaMetaElevation = true;
        this.noDeltaValue = true;
    }

    public synchronized void setCount(long count) {
        this.count = count;
    }

    public synchronized void flush() {
        this.stream = new ByteArrayOutputStream();
        this.safeDelta();
        this.readonly = false;
    }

    public byte[] toBlock(boolean compress) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(0);
        baos.write(0);
        baos.write(0);
        baos.write(0);
        byte[] payload = this.getBytes();
        if (payload.length < 128) {
            compress = false;
        }
        baos.write(compress ? 1 : 0);
        baos.write(Varint.encodeSignedLong(this.baseTimestamp));
        OutputStream out = baos;
        if (compress) {
            out = new GZIPOutputStream(out);
        }
        out.write(payload, 0, payload.length);
        out.flush();
        out.close();
        byte[] data = baos.toByteArray();
        int len = data.length;
        data[0] = (byte)(len >>> 24 & 0xFF);
        data[1] = (byte)(len >>> 16 & 0xFF);
        data[2] = (byte)(len >>> 8 & 0xFF);
        data[3] = (byte)(len & 0xFF);
        return data;
    }

    public void writeTo(OutputStream out) throws IOException {
        this.stream.writeTo(out);
    }

    public GTSEncoder cloneEmpty() {
        GTSEncoder encoder = new GTSEncoder(this.baseTimestamp);
        if (null != this.wrappingKey) {
            encoder.setWrappingKey(Arrays.copyOf(this.wrappingKey, this.wrappingKey.length));
        }
        encoder.setMetadata(this.getMetadata());
        return encoder;
    }

    public GTSEncoder clone() {
        GTSEncoder clone = this.cloneEmpty();
        clone.lastTimestamp = this.lastTimestamp;
        clone.lastGeoXPPoint = this.lastGeoXPPoint;
        clone.lastElevation = this.lastElevation;
        clone.lastLongValue = this.lastLongValue;
        clone.lastBDValue = this.lastBDValue;
        clone.lastDoubleValue = this.lastDoubleValue;
        clone.lastStringValue = this.lastStringValue;
        clone.binaryString = this.binaryString;
        clone.initialTimestamp = this.initialTimestamp;
        clone.initialGeoXPPoint = this.initialGeoXPPoint;
        clone.initialElevation = this.initialElevation;
        clone.initialLongValue = this.initialLongValue;
        clone.initialDoubleValue = this.initialDoubleValue;
        clone.initialBDValue = this.initialBDValue;
        clone.initialStringValue = this.initialStringValue;
        try {
            this.stream.writeTo(clone.stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        clone.count = this.count;
        clone.noDeltaMetaTimestamp = this.noDeltaMetaTimestamp;
        clone.noDeltaMetaLocation = this.noDeltaMetaLocation;
        clone.noDeltaMetaElevation = this.noDeltaMetaElevation;
        clone.noDeltaValue = this.noDeltaValue;
        return clone;
    }
}

