/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import com.geoxp.GeoXPLib;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.GTSStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.Map;

public class INTERPOLATE
extends GTSStackFunction {
    public INTERPOLATE(String name) {
        super(name);
    }

    @Override
    protected Map<String, Object> retrieveParameters(WarpScriptStack stack) throws WarpScriptException {
        return null;
    }

    @Override
    protected Object gtsOp(Map<String, Object> params, GeoTimeSerie gts) throws WarpScriptException {
        return INTERPOLATE.interpolate(gts);
    }

    public static GeoTimeSerie interpolate(GeoTimeSerie gts) {
        int idx;
        GeoTimeSerie filled = gts.clone();
        if (!GTSHelper.isBucketized(filled)) {
            return filled;
        }
        GTSHelper.sort(filled);
        if (filled.values < 2) {
            return filled;
        }
        int nvalues = filled.values;
        long bucket = filled.lastbucket - (long)filled.bucketcount * filled.bucketspan;
        int nElevations = 0;
        int nLocations = 0;
        if (null != filled.elevations && Long.MIN_VALUE != filled.elevations[0]) {
            ++nElevations;
        }
        if (null != filled.locations && 91480763316633925L != filled.locations[0]) {
            ++nLocations;
        }
        for (int i = 1; i < nvalues; ++i) {
            if (null != filled.elevations && Long.MIN_VALUE != filled.elevations[i]) {
                ++nElevations;
            }
            if (null != filled.locations && 91480763316633925L != filled.locations[i]) {
                ++nLocations;
            }
            while (bucket < filled.lastbucket && bucket <= filled.ticks[i - 1]) {
                bucket += filled.bucketspan;
            }
            if (bucket == filled.ticks[i]) continue;
            long tickDelta = GTSHelper.tickAtIndex(filled, i) - GTSHelper.tickAtIndex(filled, i - 1);
            double vDelta = ((Number)GTSHelper.valueAtIndex(filled, i)).doubleValue() - ((Number)GTSHelper.valueAtIndex(filled, i - 1)).doubleValue();
            double vRate = vDelta / (double)tickDelta;
            while (bucket < filled.ticks[i]) {
                long tDelta = bucket - GTSHelper.tickAtIndex(filled, i - 1);
                GTSHelper.setValue(filled, bucket, 91480763316633925L, Long.MIN_VALUE, ((Number)GTSHelper.valueAtIndex(filled, i - 1)).doubleValue() + (double)tDelta * vRate, false);
                bucket += filled.bucketspan;
            }
        }
        if (nElevations >= 2) {
            bucket = filled.lastbucket - (long)filled.bucketcount * filled.bucketspan;
            GTSHelper.sort(filled);
            idx = 0;
            while (Long.MIN_VALUE == filled.elevations[idx]) {
                ++idx;
            }
            while (idx < filled.values) {
                int i;
                for (i = idx + 1; i < filled.values && Long.MIN_VALUE != filled.elevations[i]; ++i) {
                }
                idx = i - 1;
                while (i < filled.values && Long.MIN_VALUE == filled.elevations[i]) {
                    ++i;
                }
                if (i < filled.values) {
                    double eRate = (filled.elevations[i] - filled.elevations[idx]) / (filled.ticks[i] - filled.ticks[idx]);
                    for (int j = idx + 1; j < i; ++j) {
                        filled.elevations[j] = (long)((double)filled.elevations[idx] + eRate * (double)(filled.ticks[j] - filled.ticks[idx]));
                    }
                }
                idx = i;
            }
        }
        if (nLocations >= 2) {
            bucket = filled.lastbucket - (long)filled.bucketcount * filled.bucketspan;
            GTSHelper.sort(filled);
            idx = 0;
            while (91480763316633925L == filled.locations[idx]) {
                ++idx;
            }
            while (idx < filled.values) {
                int i;
                for (i = idx + 1; i < filled.values && 91480763316633925L != filled.locations[i]; ++i) {
                }
                idx = i - 1;
                while (i < filled.values && 91480763316633925L == filled.locations[i]) {
                    ++i;
                }
                if (i < filled.values) {
                    double[] latlon_i = GeoXPLib.fromGeoXPPoint((long)filled.locations[i]);
                    double[] latlon_idx = GeoXPLib.fromGeoXPPoint((long)filled.locations[idx]);
                    double latRate = (latlon_i[0] - latlon_idx[0]) / (double)(filled.ticks[i] - filled.ticks[idx]);
                    double lonRate = (latlon_i[1] - latlon_idx[1]) / (double)(filled.ticks[i] - filled.ticks[idx]);
                    for (int j = idx + 1; j < i; ++j) {
                        double lat = latlon_idx[0] + latRate * (double)(filled.ticks[j] - filled.ticks[idx]);
                        double lon = latlon_idx[1] + lonRate * (double)(filled.ticks[j] - filled.ticks[idx]);
                        filled.locations[j] = GeoXPLib.toGeoXPPoint((double)lat, (double)lon);
                    }
                }
                idx = i;
            }
        }
        return filled;
    }
}

