/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.hadoop;

import io.warp10.hadoop.Warp10InputFormat;
import io.warp10.hadoop.WarpScriptRecordReader;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptExecutor;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class WarpScriptInputFormat
extends InputFormat<Object, Object> {
    private static final String CONFIG_SYMBOL = ".conf";
    public static final String PATH_CONFIG_KEY = ".path";
    public static final String WARPSCRIPT_INPUTFORMAT_SUFFIX = "warpscript.inputformat.suffix";
    public static final String WARPSCRIPT_INPUTFORMAT_CLASS = "warpscript.inputformat.class";
    public static final String WARPSCRIPT_INPUTFORMAT_SCRIPT = "warpscript.inputformat.script";
    public static final String WARPSCRIPT_INPUTFORMAT_CONF_SUFFIX = "warpscript.inputformat.conf.suffix";
    private InputFormat wrappedInputFormat;
    private RecordReader wrappedRecordReader;
    private String suffix = "";

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        String sfx = Warp10InputFormat.getProperty(context.getConfiguration(), this.suffix, WARPSCRIPT_INPUTFORMAT_SUFFIX, "");
        if (null != sfx) {
            this.suffix = !"".equals(sfx) ? "." + sfx : "";
        }
        this.ensureInnerFormat(context.getConfiguration());
        return this.wrappedInputFormat.getSplits(context);
    }

    private void ensureInnerFormat(Configuration conf) throws IOException {
        if (null == this.wrappedInputFormat) {
            try {
                String cls = Warp10InputFormat.getProperty(conf, this.suffix, WARPSCRIPT_INPUTFORMAT_CLASS, null);
                String confsfx = Warp10InputFormat.getProperty(conf, this.suffix, WARPSCRIPT_INPUTFORMAT_CONF_SUFFIX, "");
                if (!"".equals(confsfx)) {
                    confsfx = "." + confsfx;
                    ArrayList<Map.Entry> keys = new ArrayList<Map.Entry>();
                    for (Map.Entry entry : conf) {
                        if (!((String)entry.getKey()).endsWith(confsfx)) continue;
                        keys.add(entry);
                    }
                    for (Map.Entry entry : keys) {
                        String key = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).length() - confsfx.length());
                        conf.set(key, (String)entry.getValue());
                    }
                }
                Class<?> innerClass = Class.forName(cls);
                this.wrappedInputFormat = (InputFormat)innerClass.newInstance();
            }
            catch (Throwable t) {
                throw new IOException(t);
            }
        }
    }

    public RecordReader<Object, Object> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        if (null == this.wrappedRecordReader) {
            this.ensureInnerFormat(context.getConfiguration());
            this.wrappedRecordReader = this.wrappedInputFormat.createRecordReader(split, context);
        }
        return new WarpScriptRecordReader(this);
    }

    public WarpScriptExecutor getWarpScriptExecutor(Configuration conf, String code) throws IOException, WarpScriptException {
        if (code.startsWith("@") || code.startsWith("%")) {
            String originalfilePath = code.substring(1);
            String mc2 = this.parseWarpScript(originalfilePath);
            HashMap<String, Object> symbols = new HashMap<String, Object>();
            HashMap config = new HashMap();
            for (Map.Entry entry : conf) {
                ArrayList target = (ArrayList)config.get(entry.getKey());
                if (null == target) {
                    target = new ArrayList();
                    config.put(entry.getKey(), target);
                }
                target.add(entry.getValue());
            }
            symbols.put(CONFIG_SYMBOL, config);
            WarpScriptExecutor executor = new WarpScriptExecutor(WarpScriptExecutor.StackSemantics.PERTHREAD, mc2, symbols, null, code.startsWith("@"));
            return executor;
        }
        WarpScriptExecutor executor = new WarpScriptExecutor(WarpScriptExecutor.StackSemantics.PERTHREAD, code, null, null);
        return executor;
    }

    public String parseWarpScript(String filepath) throws IOException {
        StringBuffer scriptSB = new StringBuffer();
        InputStream fis = null;
        BufferedReader br = null;
        try {
            String line;
            fis = this.getWarpScriptInputStream(filepath);
            br = new BufferedReader(new InputStreamReader(fis, StandardCharsets.UTF_8));
            while (null != (line = br.readLine())) {
                scriptSB.append(line).append("\n");
            }
        }
        catch (IOException ioe) {
            throw new IOException("WarpScript file could not be loaded", ioe);
        }
        finally {
            if (null == br) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
            if (null == fis) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
        return scriptSB.toString();
    }

    public InputStream getWarpScriptInputStream(String originalFilePath) throws IOException {
        String filepath = Paths.get(originalFilePath, new String[0]).toString();
        InputStream fis = WarpScriptInputFormat.class.getClassLoader().getResourceAsStream(filepath);
        if (null == fis) {
            fis = new FileInputStream(filepath);
        }
        if (null == fis) {
            throw new IOException("WarpScript file '" + filepath + "' could not be found.");
        }
        return fis;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public RecordReader getWrappedRecordReader() {
        return this.wrappedRecordReader;
    }
}

