/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script;

import io.warp10.script.MemoryWarpScriptStack;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.SNAPSHOT;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class MacroHelper {
    public static WarpScriptStackFunction wrap(String name, String mc2, boolean secure) {
        if (mc2.startsWith("@")) {
            return MacroHelper.wrap(name, MacroHelper.getResource(mc2.substring(1)), secure);
        }
        MemoryWarpScriptStack stack = new MemoryWarpScriptStack(null, null);
        stack.maxLimits();
        try {
            stack.execMulti(mc2);
        }
        catch (WarpScriptException wse) {
            throw new RuntimeException(wse);
        }
        Object top = stack.pop();
        if (!(top instanceof WarpScriptStack.Macro)) {
            throw new RuntimeException("WarpScript code did not leave a macro on top of the stack.");
        }
        ((WarpScriptStack.Macro)top).setSecure(secure);
        return new MacroWrapper(name, (WarpScriptStack.Macro)top);
    }

    public static WarpScriptStackFunction wrap(String mc2, boolean secure) {
        return MacroHelper.wrap(null, mc2, secure);
    }

    public static WarpScriptStackFunction wrap(String mc2) {
        return MacroHelper.wrap(null, mc2, false);
    }

    public static WarpScriptStackFunction wrap(String name, String mc2) {
        return MacroHelper.wrap(name, mc2, false);
    }

    public static WarpScriptStackFunction wrap(String name, InputStream in, boolean secure) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int len;
            while ((len = in.read(buf)) >= 0) {
                baos.write(buf, 0, len);
            }
            in.close();
            String mc2 = new String(baos.toByteArray(), StandardCharsets.UTF_8);
            return MacroHelper.wrap(name, mc2, secure);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static WarpScriptStackFunction wrap(InputStream in, boolean secure) {
        return MacroHelper.wrap(null, in, secure);
    }

    public static WarpScriptStackFunction wrap(InputStream in) {
        return MacroHelper.wrap(null, in, false);
    }

    public static WarpScriptStackFunction wrap(String name, InputStream in) {
        return MacroHelper.wrap(name, in, false);
    }

    private static InputStream getResource(String path) {
        InputStream in = MacroHelper.class.getResourceAsStream(path.startsWith("/") ? path : "/" + path);
        if (null == in) {
            throw new RuntimeException("Resource " + path + " was not found.");
        }
        return in;
    }

    private static final class MacroWrapper
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction,
    SNAPSHOT.Snapshotable {
        private final WarpScriptStack.Macro macro;

        public MacroWrapper(String name, WarpScriptStack.Macro macro) {
            super(name);
            this.macro = macro;
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            stack.exec(this.macro);
            return stack;
        }

        @Override
        public String toString() {
            if (null != this.getName()) {
                return super.toString();
            }
            return this.macro.toString() + " " + "EVAL";
        }

        @Override
        public String snapshot() {
            if (this.macro instanceof SNAPSHOT.Snapshotable) {
                return this.macro.snapshot();
            }
            return this.toString();
        }
    }
}

